/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.exception;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.ISendMsgService;
import com.els.modules.message.handle.enums.SendMsgTypeEnum;
import com.els.modules.message.util.MessageHandleFactory;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.enums.i18n.base.Ii18nEnum;
import com.els.modules.system.util.I18nUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.validation.ConstraintViolationException;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.redis.connection.PoolException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class ELSBootExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ELSBootExceptionHandler.class);

    @ExceptionHandler(value={ELSBootException.class})
    public Result<?> handleRRException(ELSBootException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error(e.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public Result<?> handle(IllegalArgumentException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error(e.getMessage());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Result<?> handle(ConstraintViolationException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error(e.getMessage().split(",")[0].split(":")[1]);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Result<?> handlerNoFoundException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error(404, I18nUtil.translate("i18n_alert_HOxMKWVImHOKQiR_1eb5574f", "\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84\u662f\u5426\u6b63\u786e"));
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public Result<?> handleDuplicateKeyException(DuplicateKeyException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error(I18nUtil.translate("i18n_alert_WFGsIMKrtH_4dfb0d40", "\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8be5\u8bb0\u5f55"));
    }

    @ExceptionHandler(value={UnauthorizedException.class, AuthorizationException.class})
    public Result<?> handleAuthorizationException(AuthorizationException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.noauth(I18nUtil.translate("i18n_alert_BjbWWVKHRvjlb_beee0887", "\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743"));
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public Result<?> handleAuthcException(AuthenticationException e) {
        return Result.tokenExpire(e.getMessage());
    }

    private void sendMsg(Exception e) {
        ISendMsgService sendMsgHandle = MessageHandleFactory.getMsgHandle(SendMsgTypeEnum.EMAIL.getType());
        MsgVO msgVO = new MsgVO();
        ElsMsgConfigItem item = new ElsMsgConfigItem();
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String title = "\u7cfb\u7edf\u5f02\u5e38\u63d0\u793a\uff0c\u73af\u5883\uff1a" + StaticConfig.staticMap.get("serviceAddress");
        if (loginUser != null) {
            item.setMsgTitle(title + "\uff0c\u8d26\u53f7\uff1a" + loginUser.getElsAccount() + "_" + loginUser.getSubAccount());
        } else {
            item.setMsgTitle(title + "\uff0c\u8d26\u53f7\uff1a" + TenantContext.getTenant());
        }
        item.setMsgContent(this.getErrorInfoFromException(e));
        item.setMsgType("exception");
        ElsSubAccount account = new ElsSubAccount();
        account.setEmail(StaticConfig.staticMap.get("exceptionNoticeEmail"));
        msgVO.setElsMsgConfigItem(item);
        msgVO.setAccount(account);
        sendMsgHandle.sendMsg(msgVO);
    }

    public String getErrorInfoFromException(Exception e) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            e.printStackTrace(pw);
        }
        return sw.toString();
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Result<?> httpRequestMethodNotSupportedException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error(I18nUtil.translate("i18n_alert_yVVVCKxRuWVImW_5431dff1", "\u63a5\u53e3\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u652f\u6301\uff0c\u8bf7\u68c0\u67e5\uff01"));
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public Result<?> handleMaxUploadSizeExceededException(MaxUploadSizeExceededException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error(I18nUtil.translate("i18n_alert_QIfXBGWRWWVAdSPnQIRRW_91ad26c3", "\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa\u9650\u5236, \u8bf7\u538b\u7f29\u6216\u964d\u4f4e\u6587\u4ef6\u8d28\u91cf! "));
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    public Result<?> handleDataIntegrityViolationException(DataIntegrityViolationException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error(I18nUtil.translate("i18n_alert_JOEHWBGWFGJOjHz_e2a2ef66", "\u5b57\u6bb5\u592a\u957f,\u8d85\u51fa\u6570\u636e\u5e93\u5b57\u6bb5\u7684\u957f\u5ea6"));
    }

    @ExceptionHandler(value={PoolException.class})
    public Result<?> handlePoolException(PoolException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error(I18nUtil.translate("i18n_alert_WWWWWWKyIHW_ac6e977f", "Redis \u8fde\u63a5\u5f02\u5e38!"));
    }

    @ExceptionHandler(value={Exception.class})
    public Result<?> handleException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        this.sendMsg(e);
        return Result.error(CharSequenceUtil.isBlank((CharSequence)e.getMessage()) ? I18nUtil.translate("i18n_alert_TWIHWVImTWKy_b81cc2a3", "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5") : e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result<?> handleException(MethodArgumentNotValidException e) throws ClassNotFoundException {
        String msg = ((ObjectError)e.getBindingResult().getAllErrors().get(0)).getDefaultMessage();
        String[] enumsName = msg.split("::");
        Ii18nEnum ii18nEnum = (Ii18nEnum)Enum.valueOf(Class.forName(enumsName[0]), enumsName[1]);
        log.error(ii18nEnum.defaultValue(), (Throwable)e);
        return Result.error(I18nUtil.translate(ii18nEnum.i18nKey(), ii18nEnum.defaultValue()));
    }
}

