/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.ConvertUtils;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.justauth.JustAuthUtil;
import com.els.modules.justauth.entity.JustAuthConfig;
import com.els.modules.justauth.service.JustAuthConfigService;
import com.els.modules.shiro.authc.JwtToken;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.model.ThirdLoginModel;
import com.els.modules.system.service.ElsCompanySetService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ThirdAccountService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.vo.AuthCallbackVO;
import com.els.modules.system.vo.ElsCompanySetVO;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.zhyd.oauth.AuthRequestBuilder;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.utils.AuthStateUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/account/thirdLogin"})
@Api(tags={"\u7b2c\u4e09\u65b9\u767b\u5f55"})
public class ThirdLoginNewController {
    private static final Logger log = LoggerFactory.getLogger(ThirdLoginNewController.class);
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private ThirdAccountService thirdAccountService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ElsCompanySetService elsCompanySetService;
    @Autowired
    private JustAuthConfigService justAuthConfigService;
    @Value(value="${els.service.address}")
    private String baseHost;
    private static final String STATE_KEY = "sys:thirdLogin:state:";
    private static final String ACCOUNT_KEY = "sys:thirdLogin:account:";

    private AuthRequest getAuthRequest(String elsAccount, String source, String type, Boolean flag) {
        JustAuthConfig config = this.justAuthConfigService.getOneConfig(elsAccount, JustAuthUtil.getAuthConfigType(source));
        if (config == null) {
            throw new ELSBootException("\u7b2c\u4e09\u65b9\u51ed\u8bc1\u4e0d\u5b58\u5728\uff01");
        }
        String uri = "/user/qcLogin";
        if ("mobile".equals(type)) {
            uri = "/mobile";
        }
        if (flag.booleanValue()) {
            source = JustAuthUtil.getAuthType(source);
        }
        String redirectUri = String.valueOf(this.baseHost) + uri + "?type%3D" + source.toLowerCase();
        AuthRequest authRequest = AuthRequestBuilder.builder().source(source).authConfig(o -> AuthConfig.builder().clientId(config.getClientId()).clientSecret(config.getClientSecret()).agentId(config.getAgentId()).redirectUri(redirectUri).build()).build();
        return authRequest;
    }

    @AutoLog(value="\u7b2c\u4e09\u65b9\u767b\u5f55-\u4e8c\u7ef4\u7801\u6e32\u67d3")
    @GetMapping(value={"/render/{source}"})
    public void render(@PathVariable(value="source") String source, HttpServletResponse response, HttpServletRequest request) throws IOException {
        AuthRequest authRequest = this.getAuthRequest("100000", source, "pc", false);
        String state = AuthStateUtils.createState();
        String authorizeUrl = authRequest.authorize(state);
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8ba4\u8bc1\u5730\u5740\uff1a" + authorizeUrl);
        response.sendRedirect(authorizeUrl);
    }

    @AutoLog(value="\u7b2c\u4e09\u65b9\u767b\u5f55-\u6388\u6743\u767b\u5f55")
    @GetMapping(value={"/render/{elsAccount}/{type}/{source}"})
    public void render2(@PathVariable(value="elsAccount") String elsAccount, @PathVariable(value="type") String type, @PathVariable(value="source") String source, @RequestParam(name="routeUri", required=false) String routeUri, HttpServletResponse response, HttpServletRequest request) throws IOException {
        AuthRequest authRequest = this.getAuthRequest(elsAccount, source.toUpperCase(), type, true);
        String state = AuthStateUtils.createState();
        String authorizeUrl = authRequest.authorize(state);
        JSONObject object = new JSONObject();
        if (StrUtil.isNotBlank((CharSequence)routeUri)) {
            object.put("routeUri", (Object)routeUri);
            this.redisUtil.set(STATE_KEY + state, object, 1800L);
        }
        this.redisUtil.set(ACCOUNT_KEY + state, elsAccount, 1800L);
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8ba4\u8bc1\u5730\u5740\uff1a" + authorizeUrl);
        response.sendRedirect(authorizeUrl);
    }

    @AutoLog(value="\u7b2c\u4e09\u65b9\u767b\u5f55-\u7b2c\u4e09\u65b9\u626b\u7801callback")
    @GetMapping(value={"/{source}/callback"})
    public Result<?> loginThird(@PathVariable(value="source") String source, AuthCallbackVO callback) {
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\uff1a" + source + " params\uff1a" + JSONObject.toJSONString((Object)((Object)callback)));
        String elsAccount = "100000";
        boolean flag = false;
        if (this.redisUtil.get(ACCOUNT_KEY + callback.getState()) != null) {
            elsAccount = (String)this.redisUtil.get(ACCOUNT_KEY + callback.getState());
            flag = true;
        }
        AuthRequest authRequest = this.getAuthRequest(elsAccount, source.toUpperCase(), "pc", flag);
        AuthResponse response = authRequest.login((AuthCallback)callback);
        log.info(JSONObject.toJSONString((Object)response));
        Result<JSONObject> result = new Result<JSONObject>();
        if (response.getCode() == 2000) {
            JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()));
            String username = data.getString("username");
            String avatar = data.getString("avatar");
            StringBuffer uuid = new StringBuffer(data.getString("uuid"));
            ThirdLoginModel tlm = new ThirdLoginModel(JustAuthUtil.getAuthConfigType(source.toUpperCase()), uuid.toString(), username, avatar);
            ThirdAccount thrid = this.getThirdAccounts(elsAccount, JustAuthUtil.getAuthConfigType(source.toUpperCase()), uuid.toString());
            ThirdAccount user = null;
            user = thrid == null ? this.saveThirdUser(tlm) : thrid;
            if (ConvertUtils.isNotEmpty(user.getUserId())) {
                String userId = user.getUserId();
                ElsSubAccount account = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)userId));
                JSONObject busObj = (JSONObject)this.redisUtil.get(STATE_KEY + callback.getState());
                this.userInfo(account, result, busObj);
            } else {
                JSONObject obj = new JSONObject();
                obj.put("thirdUserUuid", (Object)user.getThirdUserUuid());
                result.setResult(obj);
                result.success("\u64cd\u4f5c\u6210\u529f\u4f46\u6ca1\u6709\u7ed1\u5b9a\u8d26\u53f7\uff01");
            }
        } else {
            result.setSuccess(false);
            result.setMessage("\u7b2c\u4e09\u65b9\u767b\u5f55\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return result;
    }

    private ThirdAccount getThirdAccounts(String busAccount, String source, String uuid) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(ThirdAccount::getThirdUserUuid, (Object)uuid);
        query.eq(ThirdAccount::getThirdType, (Object)source);
        query.eq(ThirdAccount::getBusAccount, (Object)busAccount);
        List list = this.thirdAccountService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (ThirdAccount)list.get(0);
        }
        return null;
    }

    private Result<JSONObject> userInfo(ElsSubAccount sysUser, Result<JSONObject> result, JSONObject busObj) {
        String syspassword = sysUser.getPassword();
        String elsAccount = sysUser.getElsAccount();
        String subAccount = sysUser.getSubAccount();
        String token = JwtUtil.sign(String.valueOf(elsAccount) + "_" + subAccount, syspassword);
        this.redisUtil.set("sys:token:" + token, token);
        this.redisUtil.expire("sys:token:" + token, 3600L);
        TenantContext.setTenant(elsAccount);
        String adminFlag = this.userRoleService.getAdminFlag(elsAccount, subAccount);
        this.redisUtil.set("sys:token:role:" + token, adminFlag);
        List<ElsCompanySetVO> list = this.elsCompanySetService.findList(elsAccount);
        JSONObject obj = new JSONObject();
        obj.put("token", (Object)token);
        obj.put("userInfo", (Object)sysUser);
        obj.put("companySet", (Object)this.getObjBySet(list));
        if (busObj != null) {
            obj.put("busObj", (Object)busObj);
        }
        result.setResult(obj);
        result.success("\u767b\u5f55\u6210\u529f");
        JwtToken jwtToken = new JwtToken(token);
        SecurityUtils.getSubject().login((AuthenticationToken)jwtToken);
        return result;
    }

    private JSONObject getObjBySet(List<ElsCompanySetVO> list) {
        JSONObject result = new JSONObject();
        for (ElsCompanySetVO set : list) {
            result.put(set.getItemCode(), (Object)set.getDefaultValue());
        }
        return result;
    }

    private ThirdAccount saveThirdUser(ThirdLoginModel tlm) {
        ThirdAccount user = new ThirdAccount();
        user.setId(IdWorker.getIdStr());
        user.setDeleted(CommonConstant.DEL_FLAG_0);
        user.setStatus(1);
        user.setThirdType(tlm.getSource());
        user.setAvatar(tlm.getAvatar());
        user.setRealname(tlm.getUsername());
        user.setThirdUserUuid(tlm.getUuid());
        user.setBusAccount("100000");
        this.thirdAccountService.save(user);
        return user;
    }
}

