/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.wechat;

import cn.hutool.json.JSONObject;
import cn.hutool.json.XML;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SpringContextUtils;
import com.els.config.JustAuthConfig;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.mapper.ThirdAccountMapper;
import com.els.modules.system.service.ThirdAccountService;
import com.els.modules.wechat.enums.AccountBindingEventEnum;
import com.els.modules.wechat.enums.WechatMsgTypeEnum;
import com.els.modules.wechat.vo.AccountBindingVO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/wechat"})
public class WechatController {
    private static final Logger log = LoggerFactory.getLogger(WechatController.class);
    @Resource
    private ThirdAccountService thirdAccountService;
    @Resource
    private ThirdAccountMapper thirdAccountMapper;

    @GetMapping(value={"/auth/{elsAccount}/{subAccount}"})
    public void auth(@PathVariable String elsAccount, @PathVariable String subAccount, @RequestParam(value="code") String code) {
        log.info("\u8fdb\u5165auth\u65b9\u6cd5\u3002\u3002\u3002\u3002\u3002");
        log.info("code={}", (Object)code);
        Map<String, String> type = SpringContextUtils.getBean(JustAuthConfig.class).getType();
        String appID = type.get("WECHAT_MP.client-id");
        String appsecret = type.get("WECHAT_MP.client-secret");
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + appID + "&secret=" + appsecret + "&code=" + code + "&grant_type=authorization_code";
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity respon = restTemplate.getForEntity(url, String.class, new Object[0]);
        log.info("respon={}", (Object)respon);
        if (HttpStatus.OK == respon.getStatusCode()) {
            String body = (String)respon.getBody();
            com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)body);
            if (jsonObject.containsKey((Object)"errcode")) {
                log.error("WechatController->auth \u6709\u8bef\uff1a{},{}", (Object)jsonObject.getString("errcode"), (Object)jsonObject.getString("errmsg"));
                return;
            }
            ThirdAccount user = new ThirdAccount();
            user.setDeleted(CommonConstant.DEL_FLAG_0);
            user.setStatus(1);
            user.setThirdType("WECHAT");
            user.setThirdUserUuid(jsonObject.getString("openid"));
            user.setUserId(subAccount);
            user.setElsAccount(elsAccount);
            user.setCreateTime(new Date());
            this.thirdAccountService.save(user);
        }
    }

    @RequestMapping(value={"/signature"})
    public void get(HttpServletRequest request, HttpServletResponse response) {
        Map<String, String> type = SpringContextUtils.getBean(JustAuthConfig.class).getType();
        String wechatToken = "Droo3C5oiomm5G1z";
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String echostr = request.getParameter("echostr");
        if (StringUtils.isNotBlank((CharSequence)echostr)) {
            this.wechatSignature(response, wechatToken, signature, timestamp, nonce, echostr);
        } else {
            this.accountBinding(request);
        }
    }

    private void accountBinding(HttpServletRequest request) {
        ServletInputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            try {
                is = request.getInputStream();
                isr = new InputStreamReader((InputStream)is, "utf-8");
                br = new BufferedReader(isr);
                String str = null;
                StringBuffer returnXml = new StringBuffer();
                while ((str = br.readLine()) != null) {
                    returnXml.append(str);
                }
                JSONObject object = XML.toJSONObject((String)returnXml.toString());
                log.info(object.toString());
                JSONObject xmlVO = object.getJSONObject((Object)"xml");
                xmlVO.getStr((Object)"FromUserName");
                AccountBindingVO vo = (AccountBindingVO)object.getBean((Object)"xml", AccountBindingVO.class);
                if (WechatMsgTypeEnum.EVENT.getCode().equals(vo.getMsgType())) {
                    if (AccountBindingEventEnum.SUBSCRIBE.getCode().equals(vo.getEvent())) {
                        String[] elsAccounts = StringUtils.substringAfter((String)vo.getEventKey(), (String)"qrscene_").split("-");
                        this.saveAccountBinding(vo, elsAccounts);
                    } else if (AccountBindingEventEnum.SCAN.getCode().equals(vo.getEvent())) {
                        String[] elsAccounts = vo.getEventKey().split("-");
                        this.saveAccountBinding(vo, elsAccounts);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void wechatSignature(HttpServletResponse response, String wechatToken, String signature, String timestamp, String nonce, String echostr) {
        PrintWriter out = null;
        try {
            try {
                out = response.getWriter();
                if (WechatController.checkSignature(wechatToken, signature, timestamp, nonce)) {
                    out.print(echostr);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                out.close();
                out = null;
            }
        }
        finally {
            out.close();
            out = null;
        }
    }

    public static boolean checkSignature(String wechatToken, String signature, String timestamp, String nonce) {
        Object[] arr = new String[]{wechatToken, timestamp, nonce};
        Arrays.sort(arr);
        StringBuilder content = new StringBuilder();
        int i = 0;
        while (i < arr.length) {
            content.append((String)arr[i]);
            ++i;
        }
        MessageDigest md = null;
        String tmpStr = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(content.toString().getBytes());
            tmpStr = WechatController.byteToStr(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        content = null;
        return tmpStr != null ? tmpStr.equals(signature.toUpperCase()) : false;
    }

    private static String byteToStr(byte[] byteArray) {
        String strDigest = "";
        int i = 0;
        while (i < byteArray.length) {
            strDigest = String.valueOf(strDigest) + WechatController.byteToHexStr(byteArray[i]);
            ++i;
        }
        return strDigest;
    }

    private static String byteToHexStr(byte mByte) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] tempArr = new char[]{Digit[mByte >>> 4 & 0xF], Digit[mByte & 0xF]};
        String s = new String(tempArr);
        return s;
    }

    private void saveAccountBinding(AccountBindingVO vo, String[] elsAccounts) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(ThirdAccount::getThirdUserUuid, (Object)vo.getFromUserName());
        query.eq(BaseEntity::getElsAccount, (Object)elsAccounts[0]);
        query.eq(ThirdAccount::getUserId, (Object)elsAccounts[1]);
        query.eq(BaseEntity::getDeleted, (Object)"0");
        int account = this.thirdAccountMapper.selectCount((Wrapper)query);
        if (account <= 0) {
            ThirdAccount user = new ThirdAccount();
            user.setDeleted(CommonConstant.DEL_FLAG_0);
            user.setStatus(1);
            user.setThirdType("wechat_mp");
            user.setThirdUserUuid(vo.getFromUserName());
            user.setElsAccount(elsAccounts[0]);
            user.setUserId(elsAccounts[1]);
            user.setCreateTime(new Date());
            this.thirdAccountService.save(user);
        }
    }
}

