/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.util;

import com.alibaba.fastjson.JSONObject;
import com.els.modules.system.util.I18nUtil;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestUtil {
    private static final RestTemplate RT = new RestTemplate();

    public static RestTemplate getRestTemplate() {
        return RT;
    }

    public static JSONObject get(String url) {
        return (JSONObject)RestUtil.getNative(url, null, null).getBody();
    }

    public static JSONObject get(String url, JSONObject variables) {
        return (JSONObject)RestUtil.getNative(url, variables, null).getBody();
    }

    public static JSONObject get(String url, JSONObject variables, JSONObject params) {
        return (JSONObject)RestUtil.getNative(url, variables, params).getBody();
    }

    public static ResponseEntity<JSONObject> getNative(String url, JSONObject variables, JSONObject params) {
        return RestUtil.request(url, HttpMethod.GET, variables, params);
    }

    public static JSONObject post(String url) {
        return (JSONObject)RestUtil.postNative(url, null, null).getBody();
    }

    public static JSONObject post(String url, JSONObject params) {
        return (JSONObject)RestUtil.postNative(url, null, params).getBody();
    }

    public static JSONObject post(String url, JSONObject variables, JSONObject params) {
        return (JSONObject)RestUtil.postNative(url, variables, params).getBody();
    }

    public static ResponseEntity<JSONObject> postNative(String url, JSONObject variables, JSONObject params) {
        return RestUtil.request(url, HttpMethod.POST, variables, params);
    }

    public static JSONObject put(String url) {
        return (JSONObject)RestUtil.putNative(url, null, null).getBody();
    }

    public static JSONObject put(String url, JSONObject params) {
        return (JSONObject)RestUtil.putNative(url, null, params).getBody();
    }

    public static JSONObject put(String url, JSONObject variables, JSONObject params) {
        return (JSONObject)RestUtil.putNative(url, variables, params).getBody();
    }

    public static ResponseEntity<JSONObject> putNative(String url, JSONObject variables, JSONObject params) {
        return RestUtil.request(url, HttpMethod.PUT, variables, params);
    }

    public static JSONObject delete(String url) {
        return (JSONObject)RestUtil.deleteNative(url, null, null).getBody();
    }

    public static JSONObject delete(String url, JSONObject variables, JSONObject params) {
        return (JSONObject)RestUtil.deleteNative(url, variables, params).getBody();
    }

    public static ResponseEntity<JSONObject> deleteNative(String url, JSONObject variables, JSONObject params) {
        return RestUtil.request(url, HttpMethod.DELETE, null, variables, params, JSONObject.class);
    }

    public static ResponseEntity<JSONObject> request(String url, HttpMethod method, JSONObject variables, JSONObject params) {
        return RestUtil.request(url, method, RestUtil.getHeaderApplicationJson(), variables, params, JSONObject.class);
    }

    public static <T> ResponseEntity<T> request(String url, HttpMethod method, HttpHeaders headers, JSONObject variables, JSONObject params, Class<T> responseType) {
        if (StringUtils.isEmpty((String)url)) {
            throw new RuntimeException(I18nUtil.translate("i18n_alert_WWWWxOLV_e7e73c21", "url \u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (method == null) {
            throw new RuntimeException(I18nUtil.translate("", "method \u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (headers == null) {
            headers = new HttpHeaders();
        }
        String body = "";
        if (params != null) {
            body = params.toJSONString();
        }
        if (variables != null) {
            url = url + "?" + RestUtil.asUrlVariables(variables);
        }
        HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
        return RT.exchange(url, method, request, responseType, new Object[0]);
    }

    private static HttpHeaders getHeaderApplicationJson() {
        return RestUtil.getHeader("application/json");
    }

    private static HttpHeaders getHeader(String mediaType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)mediaType));
        headers.add("Accept", mediaType);
        return headers;
    }

    public static String asUrlVariables(JSONObject variables) {
        Map source = variables.getInnerMap();
        Iterator it = source.keySet().iterator();
        StringBuilder urlVariables = new StringBuilder();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = "";
            Object object = source.get(key);
            if (object != null && !StringUtils.isEmpty((String)object.toString())) {
                value = object.toString();
            }
            urlVariables.append("&").append(key).append("=").append(value);
        }
        return urlVariables.substring(1);
    }
}

