/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.util.TemplateParseUtil;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.util.I18nUtil;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class EmailSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(EmailSendMsgImpl.class);
    private static String emailFrom;
    private static String[] ccEmail;

    public static void setEmail(String emailFrom, String ccEmail) {
        EmailSendMsgImpl.emailFrom = emailFrom;
        EmailSendMsgImpl.ccEmail = ccEmail.split(",");
    }

    @Override
    public void doSendMsg(MsgVO msg) {
        ElsSubAccount account = msg.getReceiveAccount();
        ElsMsgConfigItem item = msg.getElsMsgConfigItem();
        JavaMailSender mailSender = (JavaMailSender)SpringContextUtils.getBean("mailSender");
        MimeMessage message = mailSender.createMimeMessage();
        log.error("start send email to:" + account.getEmail());
        try {
            if (StrUtil.isEmpty((CharSequence)account.getEmail())) {
                log.error("::: \u6d88\u606f\u63a5\u6536\u65b9\u6ca1\u6709\u914d\u7f6e\u90ae\u7bb1\uff0c\u65e0\u6cd5\u63a5\u6536\u90ae\u7bb1\u6d88\u606f,");
                return;
            }
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom(SpringContextUtils.getBean(StaticConfig.class).getEmailFrom());
            helper.setTo(account.getEmail());
            if (!"exception".equals(item.getMsgType())) {
                String ccEmail = SpringContextUtils.getBean(StaticConfig.class).getCcEmail();
                if (StrUtil.isNotBlank((CharSequence)ccEmail)) {
                    helper.setCc(ccEmail);
                } else {
                    helper.setCc(SpringContextUtils.getBean(StaticConfig.class).getEmailFrom());
                }
            }
            helper.setSubject(item.getMsgTitle());
            String msgContent = item.getMsgContent();
            if (StrUtil.isNotBlank((CharSequence)msgContent)) {
                if (msg.getParams() != null) {
                    JSONObject object = SysUtil.objectToJSON(msg.getParams());
                    if (StrUtil.isNotBlank((CharSequence)item.getLinkUrl())) {
                        object.put("audthUrl", (Object)this.getAuthUrl(item.getLinkUrl() + "?" + msg.getUrlParam(), account));
                    }
                    msgContent = TemplateParseUtil.getTemplateText("", msgContent, (Map<String, Object>)object);
                }
                helper.setText(msgContent, true);
            }
            mailSender.send(message);
        }
        catch (MessagingException e) {
            log.error(e.getMessage());
            throw new ELSBootException(I18nUtil.translate("", "\u6d88\u606f\u7ec4\u4ef6\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
        }
    }

    private String getAuthUrl(String redirectUri, ElsSubAccount account) {
        StringBuilder url = new StringBuilder(StaticConfig.staticMap.get("serviceAddress"));
        url.append("/user/login?redirect=").append(URLUtil.encodeAll((String)redirectUri)).append("&token=").append(JwtUtil.getOutToken(account.getElsAccount() + "_" + account.getSubAccount(), account.getPassword()));
        return url.toString();
    }

    public static void main(String[] args) {
        String url = "/srm/bidding/sale/SaleBiddingHeadList?templateNumber=TC2021051401&templateVersion=1&id=1404452506648141826&busAccount=307000";
        System.out.println(URLUtil.encodeAll((String)url));
    }
}

