/*
 * Decompiled with CFR 0.152.
 */
package com.els.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RedisSessionDao
extends AbstractSessionDAO {
    private long expireTime = 3600000L;
    private static final String SESSION_PREFIX = "sys:session:";
    @Autowired
    private RedisTemplate redisTemplate;

    public RedisSessionDao() {
    }

    public RedisSessionDao(long expireTime, RedisTemplate redisTemplate) {
        this.expireTime = expireTime;
        this.redisTemplate = redisTemplate;
    }

    public void update(Session session) throws UnknownSessionException {
        if (session == null || session.getId() == null) {
            return;
        }
        session.setTimeout(this.expireTime);
        this.redisTemplate.opsForValue().set((Object)(SESSION_PREFIX + session.getId()), (Object)session, this.expireTime, TimeUnit.MILLISECONDS);
    }

    public void delete(Session session) {
        if (null == session) {
            return;
        }
        this.redisTemplate.opsForValue().getOperations().delete((Object)(SESSION_PREFIX + session.getId()));
    }

    public Collection<Session> getActiveSessions() {
        Set keys = this.redisTemplate.keys((Object)"sys:session:*");
        ArrayList<Session> sessions = new ArrayList<Session>();
        for (String key : keys) {
            Session session = (Session)this.redisTemplate.opsForValue().get((Object)key);
            sessions.add(session);
        }
        return sessions;
    }

    protected Serializable doCreate(Session session) {
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        this.redisTemplate.opsForValue().set((Object)(SESSION_PREFIX + session.getId()), (Object)session, this.expireTime, TimeUnit.MILLISECONDS);
        return sessionId;
    }

    protected Session doReadSession(Serializable sessionId) {
        if (sessionId == null) {
            return null;
        }
        return (Session)this.redisTemplate.opsForValue().get((Object)(SESSION_PREFIX + sessionId));
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

