/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.aspect;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.api.vo.Result;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.modules.system.entity.AuthSensitive;
import com.els.modules.system.service.AuthSensitiveService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.vo.UserRoleAspectVO;
import com.els.modules.template.service.TemplateHeadService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.shiro.SecurityUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthSensitiveAspect {
    private static final Logger log = LoggerFactory.getLogger(AuthSensitiveAspect.class);
    @Autowired
    private AuthSensitiveService sensitiveService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private TemplateHeadService templateHeadService;
    private final String OBJECT_CLASS = "java.lang.Object";
    private Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");

    @Pointcut(value="execution(public * com.els.modules..*.*Controller.*(..))")
    public void excudeService() {
    }

    @Around(value="excudeService()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        long time1 = System.currentTimeMillis();
        Object result = pjp.proceed();
        long time2 = System.currentTimeMillis();
        log.debug("\u83b7\u53d6JSON\u6570\u636e \u8017\u65f6\uff1a" + (time2 - time1) + "ms");
        long start = System.currentTimeMillis();
        this.parseDictText(result);
        long end = System.currentTimeMillis();
        log.debug("\u89e3\u6790\u6ce8\u5165JSON\u6570\u636e  \u8017\u65f6" + (end - start) + "ms");
        return result;
    }

    public void parseDictText(Object result) {
        if (result instanceof Result) {
            if (((Result)result).getResult() instanceof IPage) {
                ArrayList<JSONObject> items = new ArrayList<JSONObject>();
                for (Object record : ((IPage)((Result)result).getResult()).getRecords()) {
                    if (null == record) continue;
                    JSONObject item = this.parseJson(record);
                    items.add(item);
                }
                ((IPage)((Result)result).getResult()).setRecords(items);
            } else if (((Result)result).getResult() instanceof BaseEntity) {
                Object record = ((Result)result).getResult();
                ((Result)result).setResult(this.parseJson(record));
            } else if (((Result)result).getResult() instanceof List) {
                ArrayList<JSONObject> items = new ArrayList<JSONObject>();
                boolean flag = false;
                for (Object record : (List)((Result)result).getResult()) {
                    if (!(record instanceof BaseEntity)) continue;
                    JSONObject item = this.parseJson(record);
                    items.add(item);
                    flag = true;
                }
                if (flag) {
                    ((List)((Result)result).getResult()).clear();
                    ((List)((Result)result).getResult()).addAll(items);
                }
            }
        }
    }

    private JSONObject parseJson(Object record) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "{}";
        try {
            json = mapper.writeValueAsString(record);
        }
        catch (JsonProcessingException e) {
            log.error("json\u89e3\u6790\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        List<UserRoleAspectVO> list = this.userRoleService.getUserRoleByELSAccountAndSubAccount(sysUser);
        JSONObject item = JSONObject.parseObject((String)json);
        List<UserRoleAspectVO> userRolelist = list.stream().filter(s -> !s.getRoleCode().equals("companyAdmin") && !s.getRoleCode().equals("admin")).collect(Collectors.toList());
        if (userRolelist.size() > 0) {
            List<AuthSensitive> roleList = this.sensitiveService.listByRoleId(userRolelist);
            roleList.forEach(role -> {
                String authValue = role.getAuthValue();
                if (item.containsKey((Object)authValue)) {
                    item.put(authValue, null);
                }
            });
        }
        return item;
    }
}

