/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.template.util;

import com.els.common.exception.ELSBootException;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.template.util.FreeMarkerTemplateUtils;
import com.els.modules.template.vo.TemplateHeadVO;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.springframework.util.Assert;

public class ConfigPageGeneJsUtil {
    public static boolean generatorJs(String dirPath, TemplateHeadVO headVO) {
        try {
            File fileDir = new File(dirPath);
            if (!fileDir.exists()) {
                Assert.isTrue((boolean)fileDir.mkdirs(), (String)I18nUtil.translate("i18n_alert_QIcIKm_bf4b7162", "\u6587\u4ef6\u521b\u5efa\u5931\u8d25"));
            }
            HashMap<String, TemplateHeadVO> map = new HashMap<String, TemplateHeadVO>(128);
            map.put("data", headVO);
            String filePurName = "purchase_" + headVO.getBusinessType() + "_" + headVO.getTemplateNumber() + "_" + headVO.getTemplateVersion() + ".js";
            File savePurFile = new File(dirPath + File.separator, FilenameUtils.getName((String)filePurName));
            if (savePurFile.exists()) {
                Assert.isTrue((boolean)savePurFile.delete(), (String)I18nUtil.translate("i18n_alert_QIQGKm_c01dbc27", "\u6587\u4ef6\u5220\u9664\u5931\u8d25"));
            }
            Template purTemp = FreeMarkerTemplateUtils.getTemplate("js-code-pur.ftl");
            FileOutputStream fosPur = new FileOutputStream(savePurFile);
            BufferedWriter bfwPur = new BufferedWriter(new OutputStreamWriter((OutputStream)fosPur, StandardCharsets.UTF_8));
            purTemp.process(map, (Writer)bfwPur);
            bfwPur.flush();
            bfwPur.close();
            String fileSupName = "sale_" + headVO.getBusinessType() + "_" + headVO.getTemplateNumber() + "_" + headVO.getTemplateVersion() + ".js";
            File saveSupFile = new File(dirPath + File.separator, FilenameUtils.getName((String)fileSupName));
            if (saveSupFile.exists()) {
                Assert.isTrue((boolean)saveSupFile.delete(), (String)I18nUtil.translate("i18n_alert_QIQGKm_c01dbc27", "\u6587\u4ef6\u5220\u9664\u5931\u8d25"));
            }
            Template supTemp = FreeMarkerTemplateUtils.getTemplate("js-code-sup.ftl");
            FileOutputStream fosSup = new FileOutputStream(saveSupFile);
            BufferedWriter bfwSup = new BufferedWriter(new OutputStreamWriter((OutputStream)fosSup, StandardCharsets.UTF_8));
            supTemp.process(map, (Writer)bfwSup);
            bfwSup.flush();
            bfwSup.close();
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_WWWWWWWWW_c32126aa", "N-CFG-002"));
        }
        return true;
    }

    public static void main(String[] args) throws IOException, TemplateException {
        Template t = FreeMarkerTemplateUtils.getTemplate("js-code.ftl");
        HashMap<String, String> map = new HashMap<String, String>(128);
        map.put("table_name_small", "dd");
        t.process(map, (Writer)new OutputStreamWriter(System.out));
    }
}

