/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.vo.LoginUser;
import com.els.modules.system.entity.FastPermission;
import com.els.modules.system.service.FastPermissionService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.vo.PermissionVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5feb\u6377\u5e94\u7528"})
@RestController
@RequestMapping(value={"/system/fastPermission"})
public class FastPermissionController
extends BaseController<FastPermission, FastPermissionService> {
    @Autowired
    private FastPermissionService fastPermissionService;
    @Autowired
    private PermissionService permissionService;

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2", notes="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/query"})
    public Result<?> query() {
        LoginUser account = this.getCurrentUser();
        List<PermissionVO> metaList = this.permissionService.queryByAccount(account.getElsAccount(), account.getSubAccount(), 0);
        List fastPermissionList = this.fastPermissionService.list((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)account.getId()));
        List permissionIdList = fastPermissionList.stream().map(FastPermission::getPermissionId).collect(Collectors.toList());
        ArrayList<PermissionVO> resultList = new ArrayList<PermissionVO>();
        for (PermissionVO vo : metaList) {
            if (!permissionIdList.contains(vo.getId())) continue;
            vo.setName(I18nUtil.translate(vo.getNameI18nKey(), vo.getName()));
            resultList.add(vo);
        }
        return Result.ok(resultList);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u5217\u8868\u67e5\u8be2", notes="\u8bbe\u7f6e\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryAll"})
    public Result<?> queryAll() {
        LoginUser account = this.getCurrentUser();
        List<PermissionVO> metaList = this.permissionService.queryByAccount(account.getElsAccount(), account.getSubAccount(), 0);
        List fastPermissionList = this.fastPermissionService.list((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)account.getId()));
        List permissionIdList = fastPermissionList.stream().map(FastPermission::getPermissionId).collect(Collectors.toList());
        ArrayList<PermissionVO> resultList = new ArrayList<PermissionVO>();
        for (PermissionVO vo : metaList) {
            if (vo.getMenuType().intValue() != CommonConstant.MENU_TYPE_1.intValue() || "layouts/RouteView".equals(vo.getComponent())) continue;
            if (permissionIdList.contains(vo.getId())) {
                vo.setSelected("1");
            } else {
                vo.setSelected("0");
            }
            vo.setName(I18nUtil.translate(vo.getNameI18nKey(), vo.getName()));
            resultList.add(vo);
        }
        return Result.ok(resultList);
    }

    @AutoLog(value="\u5feb\u6377\u5e94\u7528-\u4fdd\u5b58")
    @ApiOperation(value="\u4fdd\u5b58", notes="\u4fdd\u5b58")
    @GetMapping(value={"/save"})
    public Result<?> save(@RequestParam(name="ids", required=true) String ids) {
        LoginUser account = this.getCurrentUser();
        this.fastPermissionService.delFastPermission(account.getId());
        String[] idArray = ids.split(",");
        ArrayList<FastPermission> fastPermissionList = new ArrayList<FastPermission>();
        for (String id : idArray) {
            FastPermission fastPermission = new FastPermission();
            fastPermission.setPermissionId(id);
            fastPermission.setUserId(account.getId());
            fastPermissionList.add(fastPermission);
        }
        if (!fastPermissionList.isEmpty()) {
            this.fastPermissionService.saveBatch(fastPermissionList);
        }
        return this.commonSuccessResult(3);
    }
}

