/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.poi.excel.view;

import com.els.framework.poi.word.WordExportUtil;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.view.AbstractView;

@Controller(value="ilsTemplateWordView")
public class ELSTemplateWordView
extends AbstractView {
    private static final String CONTENT_TYPE = "application/msword";

    public ELSTemplateWordView() {
        this.setContentType(CONTENT_TYPE);
    }

    public boolean isIE(HttpServletRequest request) {
        return request.getHeader("USER-AGENT").toLowerCase().indexOf("msie") > 0 || request.getHeader("USER-AGENT").toLowerCase().indexOf("rv:11.0") > 0;
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String codedFileName = "\u4e34\u65f6\u6587\u4ef6.docx";
        if (model.containsKey("fileName")) {
            codedFileName = (String)model.get("fileName") + ".docx";
        }
        codedFileName = this.isIE(request) ? URLEncoder.encode(codedFileName, "UTF8") : new String(codedFileName.getBytes("UTF-8"), "ISO-8859-1");
        response.setHeader("content-disposition", "attachment;filename=" + codedFileName);
        XWPFDocument document = WordExportUtil.exportWord07((String)model.get("url"), (Map<String, Object>)((Map)model.get("map")));
        ServletOutputStream out = response.getOutputStream();
        document.write((OutputStream)out);
        out.flush();
        out.close();
        document.close();
    }
}

