/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dashboard.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.enums.SourceTypeEnum;
import com.els.common.exception.ELSBootException;
import com.els.modules.dashboard.entity.ChartData;
import com.els.modules.dashboard.service.ChartDataService;
import com.els.modules.system.service.AbstractExcelHandler;
import com.els.modules.system.util.I18nUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ChartDataExcelHandler
extends AbstractExcelHandler {
    @Autowired
    private ChartDataService chartDataService;

    @Override
    public void importExcel(List<Map<String, Object>> dataList) {
        Assert.notEmpty(dataList, (String)I18nUtil.translate("i18n_alert_uNjWFLV_844b6139", "\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a"));
        List<ChartData> chartDataList = ((Stream)dataList.stream().parallel()).map(JSON::toJSONString).map(json -> (ChartData)JSON.parseObject((String)json, ChartData.class)).collect(Collectors.toList());
        ChartData one = (ChartData)((LambdaQueryChainWrapper)this.chartDataService.lambdaQuery().in(ChartData::getDataCode, (Collection)chartDataList.parallelStream().map(ChartData::getDataCode).collect(Collectors.toList()))).one();
        if (one != null) {
            throw new ELSBootException("\u5b58\u5728\u56fe\u8868\u6570\u636e\uff1a" + one.getDataCode());
        }
        for (ChartData chartData : chartDataList) {
            chartData.setSourceType(SourceTypeEnum.EXCEL.getValue());
        }
        chartDataList.forEach(this.chartDataService::saveChartData);
    }
}

