/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.util.TemplateParseUtil;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.util.I18nUtil;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class EmailSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(EmailSendMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        ElsSubAccount account = msg.getReceiveAccount();
        Map<String, List<ElsMsgConfigItem>> elsMsgConfigItem = msg.getElsMsgConfigItem();
        List<ElsMsgConfigItem> elsMsgConfigItems = elsMsgConfigItem.get(msg.getBusAccount());
        if (CollectionUtil.isEmpty(elsMsgConfigItems)) {
            elsMsgConfigItems = elsMsgConfigItem.get(msg.getToElsAccount());
            boolean configFlag = this.checkIfConfigByCurrentAccount(msg, msg.getBusAccount());
            if (CollectionUtil.isEmpty(elsMsgConfigItems) && configFlag) {
                log.error("EmailSendMsgImpl\u5f53\u524d\u8d26\u53f7{}\u6ca1\u6709\u6ca1\u6709\u914d\u7f6e\u90ae\u7bb1\u53d1\u9001:{}", (Object)msg.getBusAccount(), (Object)msg.toString());
                return;
            }
            if (CollectionUtil.isEmpty(elsMsgConfigItems) && !configFlag) {
                elsMsgConfigItems = elsMsgConfigItem.get("100000");
            }
        }
        if (CollectionUtil.isEmpty(elsMsgConfigItems)) {
            return;
        }
        log.error("start send email to:" + account.getEmail());
        ElsMsgConfigItem item = elsMsgConfigItems.get(0);
        msg.setMsgContent(item.getMsgContent());
        log.info("EmailSendMsgImpl ==> start send email to:" + account.getEmail());
        try {
            JavaMailSender mailSender = (JavaMailSender)SpringContextUtils.getBean("mailSender");
            MimeMessage message = mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setTo(account.getEmail());
            helper.setSubject(item.getMsgTitle());
            helper.setFrom(SpringContextUtils.getBean(StaticConfig.class).getEmailFrom());
            String msgContent = item.getMsgContent();
            if (CharSequenceUtil.isNotBlank((CharSequence)msgContent)) {
                if (msg.getParams() != null) {
                    JSONObject object = SysUtil.objectToJSON(msg.getParams());
                    if (CharSequenceUtil.isNotBlank((CharSequence)item.getLinkUrl())) {
                        object.put("audthUrl", (Object)this.getAuthUrl(item.getLinkUrl() + "?" + msg.getUrlParam(), account));
                    }
                    msgContent = TemplateParseUtil.getTemplateText("", msgContent, (Map<String, Object>)object);
                }
                helper.setText(msgContent, true);
            }
            mailSender.send(message);
            log.info("EmailSendMsgImpl ==>:::end to send email...");
        }
        catch (MessagingException e) {
            log.error("EmailSendMsgImpl ==>{}", (Object)e.getMessage());
            throw new ELSBootException(I18nUtil.translate("", "\u6d88\u606f\u7ec4\u4ef6\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
        }
    }

    private String getAuthUrl(String redirectUri, ElsSubAccount account) {
        StringBuilder url = new StringBuilder(StaticConfig.staticMap.get("serviceAddress"));
        url.append("/user/login?redirect=").append(URLUtil.encodeAll((String)redirectUri)).append("&token=").append(JwtUtil.getOutToken(account.getElsAccount() + "_" + account.getSubAccount(), account.getPassword()));
        return url.toString();
    }

    public static void main(String[] args) {
        String url = "/srm/bidding/sale/SaleBiddingHeadList?templateNumber=TC2021051401&templateVersion=1&id=1404452506648141826&busAccount=307000";
        System.out.println(URLUtil.encodeAll((String)url));
    }
}

