/*
 * Decompiled with CFR 0.152.
 */
package com.els.aop;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.util.IPUtils;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StopWatch;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Configuration
public class LogAOP {
    private final ThreadLocal<String> requestId = new ThreadLocal();
    private final ThreadLocal<StopWatch> stopWatchThreadLocal = new ThreadLocal();
    private static final int PRINT_LENGTH = 1000;
    private static final Logger log = LoggerFactory.getLogger(LogAOP.class);

    @Pointcut(value="execution(public * com.els.modules..*.*Controller.*(..)) or execution(public * com.els.modules.*.*Service.*(..))")
    public void executionService() {
    }

    @Before(value="executionService()")
    public void doBefore(JoinPoint joinPoint) {
        String id = IdWorker.getIdStr();
        MDC.put((String)"requestId", (String)id);
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (attributes != null);
        HttpServletRequest request = attributes.getRequest();
        String ip = IPUtils.getIpAddr(request);
        String method = request.getMethod();
        String url = String.valueOf(request.getRequestURL());
        String controllerName = joinPoint.getSignature().getDeclaringTypeName();
        String controllerMethodName = joinPoint.getSignature().getName();
        this.requestId.set(id);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.stopWatchThreadLocal.set(stopWatch);
        log.info("\u8bf7\u6c42ID\uff1a{}\uff0cIP\uff1a{}\uff0c\u8bf7\u6c42\u65b9\u5f0f\uff1a{}\uff0c\u63a5\u53e3\u5730\u5740\uff1a{}\uff0c\u63a7\u5236\u5668\uff1a{}\uff0c\u65b9\u6cd5\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{this.requestId.get(), ip, method, url, controllerName, controllerMethodName, joinPoint.getArgs()});
    }

    @AfterReturning(pointcut="executionService()", returning="obj")
    public void doAfterReturning(JoinPoint joinPoint, Object obj) {
        StopWatch stopWatch = this.stopWatchThreadLocal.get();
        stopWatch.stop();
        String resultStr = obj.toString();
        if (log.isTraceEnabled()) {
            log.trace("\u8bf7\u6c42ID\uff1a{}\uff0c\u8017\u65f6\uff1a{}\u79d2\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a{}", new Object[]{this.requestId.get(), stopWatch.getTotalTimeSeconds(), resultStr});
        } else if (resultStr.length() <= 1000) {
            log.info("\u8bf7\u6c42ID\uff1a{}\uff0c\u8017\u65f6\uff1a{}\u79d2\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a{}", new Object[]{this.requestId.get(), stopWatch.getTotalTimeSeconds(), resultStr});
        } else {
            log.info("\u8bf7\u6c42ID\uff1a{}\uff0c\u8017\u65f6\uff1a{}\u79d2\uff0c\u54cd\u5e94\u6570\u636e\u957f\u5ea6\uff1a{}\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a{}", new Object[]{this.requestId.get(), stopWatch.getTotalTimeSeconds(), resultStr.length(), resultStr.substring(0, 1000) + "..."});
        }
        this.requestId.remove();
        this.stopWatchThreadLocal.remove();
    }
}

