/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.aspect;

import cn.hutool.core.util.StrUtil;
import com.els.common.aspect.annotation.Enhance;
import com.els.common.groovy.EnhanceGroovyFactory;
import com.els.common.service.EnhanceService;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.EnhanceConfig;
import com.els.modules.system.service.EnhanceConfigService;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class EnhanceAspect {
    private static ThreadLocal<String> purchaseAccount = new ThreadLocal();
    @Autowired
    private EnhanceConfigService enhanceConfigService;

    @Pointcut(value="@annotation(com.els.common.aspect.annotation.Enhance)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object arround(ProceedingJoinPoint point) throws Throwable {
        EnhanceConfig enhanceConfig;
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        Enhance enhance = method.getAnnotation(Enhance.class);
        String enhancePoint = enhance.enhancePoint();
        String elsAccount = StringUtils.isNotBlank((CharSequence)EnhanceAspect.getPurchaseAccount()) ? EnhanceAspect.getPurchaseAccount() : TenantContext.getTenant();
        EnhanceAspect.clear();
        if (StrUtil.isNotBlank((CharSequence)enhancePoint) && (enhanceConfig = this.enhanceConfigService.findEnhanceConfig(elsAccount, enhancePoint)) != null) {
            EnhanceService service = null;
            if (StrUtil.isNotBlank((CharSequence)enhanceConfig.getEnhanceBean())) {
                service = EnhanceGroovyFactory.getInstance().getEnhanceServiceFromCode(enhanceConfig.getEnhanceBean());
            } else if (StrUtil.isNotBlank((CharSequence)enhanceConfig.getEnhanceBeanName())) {
                service = (EnhanceService)SpringContextUtils.getBean(enhanceConfig.getEnhanceBeanName());
            }
            if (service != null) {
                if (service.isEnhance()) {
                    service.executeBefore(point.getArgs());
                    Object result = point.proceed();
                    service.executeAfter(point.getArgs(), result);
                    return result;
                }
                return service.execute(point.getArgs());
            }
        }
        return point.proceed();
    }

    public static void setPurchaseAccount(String elsAccount) {
        purchaseAccount.set(elsAccount);
    }

    public static String getPurchaseAccount() {
        return purchaseAccount.get();
    }

    public static void clear() {
        purchaseAccount.remove();
    }
}

