/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsTax;
import com.els.modules.system.mapper.ElsTaxMapper;
import com.els.modules.system.service.CompanyInterfaceConfigItemService;
import com.els.modules.system.service.ElsTaxService;
import com.els.modules.system.util.I18nUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsTaxServiceImpl
extends ServiceImpl<ElsTaxMapper, ElsTax>
implements ElsTaxService {
    @Resource
    private CompanyInterfaceConfigItemService companyInterfaceConfigItemService;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Autowired
    private RedisUtil redisUtil;
    private static final String CATALOGUE = "sys:tax:accountTax";
    private static final String COLON = ":";

    @Override
    public void saveElsTax(ElsTax elsTax) {
        ((ElsTaxMapper)this.baseMapper).insert(elsTax);
    }

    @Override
    public void updateElsTax(ElsTax elsTax) {
        ((ElsTaxMapper)this.baseMapper).updateById(elsTax);
    }

    @Override
    public void delElsTax(String id) {
        ((ElsTaxMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsTax(List<String> idList) {
        ((ElsTaxMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Map<String, Integer> getAllTax(String purchaseElsAccount) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)purchaseElsAccount);
        List taxList = this.list((Wrapper)queryWrapper);
        if (taxList.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            taxList = this.list((Wrapper)queryWrapper);
        }
        return taxList.stream().filter(tax -> StringUtils.isNotBlank((CharSequence)tax.getTaxCode())).collect(Collectors.toMap(ElsTax::getTaxCode, ElsTax::getTaxRate));
    }

    @Override
    public Map<Integer, String> getAllTaxCode(String purchaseElsAccount) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)purchaseElsAccount);
        List taxList = this.list((Wrapper)queryWrapper);
        if (taxList.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            taxList = this.list((Wrapper)queryWrapper);
        }
        return taxList.stream().filter(tax -> StringUtils.isNotBlank((CharSequence)tax.getTaxCode())).collect(Collectors.toMap(ElsTax::getTaxRate, ElsTax::getTaxCode));
    }

    @Override
    public List<ElsTax> getAccountTax(String purchaseElsAccount) {
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(purchaseElsAccount).append(COLON);
        List taxList = JSONArray.parseArray((String)this.redisUtil.get(redisKey.toString()).toString(), ElsTax.class);
        if (this.redisUtil.get(redisKey.toString()) == null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)purchaseElsAccount);
            taxList = this.list((Wrapper)queryWrapper);
            this.redisUtil.set(redisKey.toString(), taxList, 1800L);
        }
        return taxList;
    }

    @Override
    public List<ElsTax> getElsTaxByCode(String elsAccount, List<String> taxCode) {
        LambdaQueryWrapper sw = Wrappers.lambdaQuery();
        sw.select(new SFunction[]{ElsTax::getTaxCode, ElsTax::getTaxRate, ElsTax::getTaxName});
        ((LambdaQueryWrapper)sw.eq(BaseEntity::getElsAccount, (Object)elsAccount)).in(ElsTax::getTaxCode, taxCode);
        return ((ElsTaxMapper)this.baseMapper).selectList((Wrapper)sw);
    }

    @Override
    public void getErpData(String interfaceCode) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, interfaceCode, (Object)new JSONObject());
    }

    @Override
    public void addToEnterprise(String id) {
        ElsTax tax = (ElsTax)this.getById((Serializable)((Object)id));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ElsTax::getTaxCode, (Object)tax.getTaxCode());
        wrapper.eq(ElsTax::getTaxRate, (Object)tax.getTaxRate());
        wrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        Integer count = ((ElsTaxMapper)this.baseMapper).selectCount((Wrapper)wrapper);
        if (count > 0) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_foWWWWWfIWWWWIMK_6d8f1fd0", "\u7a0e\u7801${0}-\u7a0e\u7387${1}\u5df2\u5b58\u5728", tax.getTaxCode(), tax.getTaxRate() + ""));
        }
        tax.setId(null);
        tax.setUpdateBy(null);
        tax.setUpdateTime(null);
        tax.setCreateBy(null);
        tax.setCreateTime(null);
        tax.setElsAccount(TenantContext.getTenant());
        this.save(tax);
    }
}

