/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.system.base.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.els.api.dto.SelectionsDto;
import com.els.common.api.vo.Result;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.ExcelImportUtil;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.entity.ImportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.system.util.I18nUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class BaseController<T, S extends IService<T>> {
    private static final Logger log = LoggerFactory.getLogger(BaseController.class);
    @Autowired
    protected S service;
    protected final String PAGE_NO = "pageNo";
    protected final String PAGE_SIZE = "pageSize";
    protected final String DEFAULT_PAGE_NO = "1";
    protected final String DEFAULT_PAGE_SIZE = "10";

    protected ModelAndView exportXls(HttpServletRequest request, T object, Class<T> clazz, String title, SelectionsDto selectionsDto) {
        List<String> selectionList;
        QueryWrapper<T> queryWrapper = QueryGenerator.initQueryWrapper(object, request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String[] ids = selectionsDto.getSelections();
        if (ConvertUtils.isNotEmpty(ids) && CollectionUtil.isNotEmpty(selectionList = Arrays.asList(ids))) {
            queryWrapper.clear();
            Map parameterMap = request.getParameterMap();
            QueryGenerator.doMultiFieldsOrder(queryWrapper, parameterMap, object);
            queryWrapper.in((Object)"id", selectionList);
        }
        if (null != request.getAttribute("exportLimit")) {
            queryWrapper.last(" limit " + (Integer)request.getAttribute("exportLimit"));
        }
        List exportList = this.service.list(queryWrapper);
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)title);
        mv.addObject("entity", clazz);
        String defineColumn = request.getParameter("defineColumnCode");
        mv.addObject("params", (Object)new ExportParams(title, "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), title, defineColumn));
        mv.addObject("data", (Object)exportList);
        return mv;
    }

    protected <T> void exportSelectionsFilter(HttpServletRequest request, QueryWrapper<T> queryWrapper, T object) {
        List<String> selectionList;
        String selections = request.getParameter("selections");
        if (ConvertUtils.isNotEmpty(selections) && CollectionUtil.isNotEmpty(selectionList = Arrays.asList(selections.split(",")))) {
            queryWrapper.clear();
            Map parameterMap = request.getParameterMap();
            QueryGenerator.doMultiFieldsOrder(queryWrapper, parameterMap, object);
            queryWrapper.in((Object)"id", selectionList);
        }
    }

    protected List<T> exportDataFilter(HttpServletRequest request, List<T> pageList) {
        List<T> exportList = pageList;
        String selections = request.getParameter("selections");
        if (ConvertUtils.isNotEmpty(selections)) {
            List<String> selectionList = Arrays.asList(selections.split(","));
            exportList = pageList.stream().filter(item -> selectionList.contains(this.getId(item))).collect(Collectors.toList());
        }
        return exportList;
    }

    protected ModelAndView exportXls(HttpServletRequest request, List<T> pageList, Class<T> clazz, String title) {
        List<T> exportList;
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String selections = request.getParameter("selections");
        if (ConvertUtils.isNotEmpty(selections)) {
            List<String> selectionList = Arrays.asList(selections.split(","));
            exportList = pageList.stream().filter(item -> selectionList.contains(this.getId(item))).collect(Collectors.toList());
        } else {
            exportList = pageList;
        }
        String defineColumn = request.getParameter("defineColumnCode");
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)title);
        mv.addObject("entity", clazz);
        mv.addObject("params", (Object)new ExportParams(title + "\u62a5\u8868", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), title, defineColumn));
        mv.addObject("data", exportList);
        return mv;
    }

    private String getId(T item) {
        try {
            return PropertyUtils.getProperty(item, (String)"id").toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result<?> importExcel(HttpServletRequest request, HttpServletResponse response, Class<T> clazz) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List list = ExcelImportUtil.importExcel(new BufferedInputStream(file.getInputStream()), clazz, params);
                long start = System.currentTimeMillis();
                this.service.saveBatch(list);
                log.info("\u6d88\u8017\u65f6\u95f4" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
                Result<Object> result = Result.ok(I18nUtil.translate("i18n_alert_QIuNLRWWFcW_6e8a1fc", "\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570:${0}", String.valueOf(list.size())));
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result<Object> result = Result.error(I18nUtil.translate("i18n_alert_QIuNKm_c396138c", "\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:") + e.getMessage());
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error(I18nUtil.translate("i18n_alert_QIuNKm_c396138c", "\u6587\u4ef6\u5bfc\u5165\u5931\u8d25!"));
    }

    protected Result<?> commonSuccessResult(int operateType) {
        return Result.ok(I18nUtil.translate("i18n_title_operationSuccess", "\u64cd\u4f5c\u6210\u529f!"));
    }

    protected String getTenantId() {
        return TenantContext.getTenant();
    }

    protected LoginUser getCurrentUser() {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        return sysUser;
    }
}

