/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.trace;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.trace.TraceIdType;

public class TraceIdUtil {
    public static String generate(TraceIdType type) {
        if (null == type) {
            return IdWorker.get32UUID();
        }
        switch (type) {
            case MQ: {
                return TraceIdUtil.generateMqTraceId();
            }
            case JOB: {
                return TraceIdUtil.generateJobTraceId();
            }
            case OUT: {
                return TraceIdUtil.generateOutTraceId();
            }
        }
        return IdWorker.get32UUID();
    }

    public static String generateMqTraceId() {
        return TraceIdType.MQ.getPrefix() + IdWorker.get32UUID();
    }

    public static Boolean fromMq(String traceId) {
        return StrUtil.isNotEmpty((CharSequence)traceId) && traceId.startsWith(TraceIdType.MQ.getPrefix());
    }

    public static String generateJobTraceId() {
        return TraceIdType.JOB.getPrefix() + IdWorker.get32UUID();
    }

    public static Boolean fromJob(String traceId) {
        return StrUtil.isNotEmpty((CharSequence)traceId) && traceId.startsWith(TraceIdType.JOB.getPrefix());
    }

    public static String generateOutTraceId() {
        return TraceIdType.OUT.getPrefix() + IdWorker.get32UUID();
    }

    public static Boolean fromOut(String traceId) {
        return StrUtil.isNotEmpty((CharSequence)traceId) && traceId.startsWith(TraceIdType.OUT.getPrefix()) || traceId.length() == 32 || TraceIdUtil.fromJob(traceId) == false && TraceIdUtil.fromMq(traceId) == false;
    }

    public static TraceIdType getTraceIdType(String traceId) {
        if (TraceIdUtil.fromMq(traceId).booleanValue()) {
            return TraceIdType.MQ;
        }
        if (TraceIdUtil.fromJob(traceId).booleanValue()) {
            return TraceIdType.JOB;
        }
        return TraceIdType.OUT;
    }
}

