/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.justauth.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.justauth.enumerate.CustomAuthSource;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.scope.AuthScope;
import me.zhyd.oauth.enums.scope.AuthWeChatEnterpriseWebScope;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.log.Log;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AbstractAuthWeChatEnterpriseRequest;
import me.zhyd.oauth.utils.AuthChecker;
import me.zhyd.oauth.utils.AuthScopeUtils;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.UrlBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthWeChatEnterpriseThirdRequest
extends AbstractAuthWeChatEnterpriseRequest {
    private static final Logger log = LoggerFactory.getLogger(AuthWeChatEnterpriseThirdRequest.class);

    public AuthWeChatEnterpriseThirdRequest(AuthConfig config) {
        super(config, (AuthSource)CustomAuthSource.WECHAT_ENTERPRISE_THIRD);
    }

    public AuthWeChatEnterpriseThirdRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, (AuthSource)CustomAuthSource.WECHAT_ENTERPRISE_THIRD, authStateCache);
    }

    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl((String)this.source.authorize()).queryParam("appid", (Object)this.config.getClientId()).queryParam("redirect_uri", (Object)this.config.getRedirectUri()).queryParam("response_type", (Object)"code").queryParam("scope", (Object)this.getScopes(",", false, AuthScopeUtils.getDefaultScopes((AuthScope[])AuthWeChatEnterpriseWebScope.values()))).queryParam("state", (Object)this.getRealState(state).concat("#wechat_redirect")).build();
    }

    public AuthResponse login(AuthCallback authCallback) {
        try {
            if (!this.config.isIgnoreCheckState()) {
                AuthChecker.checkState((String)authCallback.getState(), (AuthSource)this.source, (AuthStateCache)this.authStateCache);
            }
            AuthToken accessToken = this.getAccessToken(authCallback);
            AuthUser user = this.getUserInfo(accessToken);
            return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data((Object)user).build();
        }
        catch (Exception e) {
            Log.error((String)"Failed to login with oauth authorization.", (Throwable)e);
            int errorCode = AuthResponseStatus.FAILURE.getCode();
            String errorMsg = e.getMessage();
            if (e instanceof AuthException) {
                AuthException authException = (AuthException)e;
                errorCode = authException.getErrorCode();
                if (StringUtils.isNotEmpty((CharSequence)authException.getErrorMsg())) {
                    errorMsg = authException.getErrorMsg();
                }
            }
            return AuthResponse.builder().code(errorCode).msg(errorMsg).build();
        }
    }

    protected AuthToken getAccessToken(AuthCallback authCallback) {
        String suiteTicket = this.authStateCache.get("suite_ticket::" + this.config.getClientId());
        String suiteAccessToken = this.authStateCache.get("suite_access_token::" + this.config.getClientId());
        if (StringUtils.isNotEmpty((CharSequence)suiteAccessToken)) {
            AuthToken authToken = AuthToken.builder().accessToken(suiteAccessToken).build();
            authToken.setCode(authCallback.getCode());
            return authToken;
        }
        if (StringUtils.isNotEmpty((CharSequence)suiteTicket)) {
            JSONObject body = new JSONObject();
            body.put("suite_id", (Object)this.config.getClientId());
            body.put("suite_secret", (Object)this.config.getClientSecret());
            body.put("suite_ticket", (Object)suiteTicket);
            String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.accessToken(), body.toJSONString()).getBody();
            JSONObject jsonObject = JSON.parseObject((String)response);
            this.checkResponse(jsonObject.toJSONString());
            AuthToken authToken = AuthToken.builder().accessToken(jsonObject.getString("suite_access_token")).expireIn(jsonObject.getIntValue("expires_in")).build();
            this.authStateCache.cache(this.config.getClientId(), jsonObject.getString("suite_access_token"), (long)jsonObject.getIntValue("expires_in"));
            authToken.setCode(authCallback.getCode());
            return authToken;
        }
        throw new AuthException("error, suite ticket not found!");
    }

    protected AuthUser getUserInfo(AuthToken authToken) {
        JSONObject response = this.checkResponse(this.doGetUserInfo(authToken));
        return AuthUser.builder().rawUserInfo(response).build();
    }

    protected String doGetUserInfo(AuthToken authToken) {
        log.info(":::\u4e34\u65f6\u6388\u6388\u6743\u7801 doGetUserInfo auth_code:{}", (Object)authToken.getCode());
        return new HttpUtils(this.config.getHttpConfig()).get(this.userInfoUrl(authToken)).getBody();
    }

    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl((String)this.source.userInfo()).queryParam("suite_access_token", (Object)authToken.getAccessToken()).queryParam("code", (Object)authToken.getCode()).build();
    }

    private JSONObject checkResponse(String response) {
        JSONObject object = JSONObject.parseObject((String)response);
        if (object.containsKey((Object)"errcode") && object.getIntValue("errcode") != 0) {
            throw new AuthException(object.getString("errmsg"), this.source);
        }
        return object;
    }
}

