/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SqlInjectionUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelByConfigDTO;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.modules.system.service.AbstractExcelHandler;
import com.els.modules.system.service.BackgroundFileTaskService;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.impl.DictServiceImpl;
import com.els.modules.system.util.ExcelGenerateRunner;
import com.els.modules.system.util.ExcelRedisKeyGenerateUtil;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.vo.ErrorExcelImportDataVO;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelDataListener
extends AnalysisEventListener<Map<Integer, String>> {
    private static final Logger log = LoggerFactory.getLogger(ExcelDataListener.class);
    private DictService dictService;
    private AbstractExcelHandler handler;
    private List<Map<String, Object>> importDataList = new ArrayList<Map<String, Object>>();
    private Map<String, Object> primaryMap = new HashMap<String, Object>(16);
    private List<ExcelDetail> excelDetailList;
    private List<String> fileHeadTitle;
    private int row = 0;
    private ExcelImportRpcService service;
    private String dataKey;
    private String errorExcelKey;
    private final String excelBusinessOptType;
    private final String excelBusinessOptTypeName;
    private List<Map<String, Object>> otherSheetList;
    private final ErrorExcelImportDataVO errorExcelImportDataVO = new ErrorExcelImportDataVO();
    private final String elsAccount;
    private final ExcelByConfigDTO excelByConfigDTO;
    private final Map<String, Object> otherRequestParam;
    private String interfaceMsg;
    private long successCount;
    private long failCount;
    String errorTitle = I18nUtil.translate("", "\u9519\u8bef\u7ed3\u679c\u8bb0\u5f55");
    String errorStatus = I18nUtil.translate("", "\u5904\u7406\u72b6\u6001");

    public ExcelDataListener(ExcelImportRpcService service, List<ExcelDetail> excelDetailList, String dataKey, List<Map<String, Object>> otherSheetList, String excelBusinessOptType, String excelBusinessOptTypeName, String elsAccount, ExcelByConfigDTO excelByConfigDTO, Map<String, Object> otherRequestParam) {
        this.service = service;
        this.excelDetailList = excelDetailList;
        this.dataKey = dataKey;
        this.otherSheetList = otherSheetList;
        this.excelBusinessOptType = excelBusinessOptType;
        this.excelBusinessOptTypeName = excelBusinessOptTypeName;
        this.elsAccount = elsAccount;
        this.excelByConfigDTO = excelByConfigDTO;
        this.otherRequestParam = otherRequestParam;
        this.dictService = SpringContextUtils.getBean(DictServiceImpl.class);
    }

    public List<Map<String, Object>> getImportDataList() {
        return this.importDataList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDictValue(ExcelDetail detail, String val, String busAccount) {
        String dictCode = detail.getDataFormat();
        if (!dictCode.contains("#")) {
            if (!dictCode.contains(",")) return this.dictService.queryDictValueByText(dictCode, val, busAccount);
        }
        String[] params = null;
        params = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
        if (params.length < 3) {
            throw new ELSBootException(I18nUtil.translate("", "\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e"));
        }
        String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
        SqlInjectionUtil.filterContent(sqlInjCheck);
        if (params.length != 4) throw new ELSBootException(I18nUtil.translate("", "\u5b57\u5178\u4e0d\u5339\u914d"));
        String filterSql = params[3] + " and " + params[1] + " = '" + val + "'";
        SqlInjectionUtil.filterContent(filterSql);
        return this.dictService.queryTableDictTextByFilterSql(params[0], params[2], filterSql, busAccount);
    }

    public void invoke(Map<Integer, String> data, AnalysisContext context) {
        long emptySize;
        ++this.row;
        if (this.row == 1) {
            this.fileHeadTitle = Lists.newArrayList(data.values());
            if (this.excelBusinessOptType.equals("SupplierMasterDataExcelHandler")) {
                this.errorExcelImportDataVO.setImportSupplierExcelHead(this.fileHeadTitle);
            } else {
                this.errorExcelImportDataVO.setExcelHead(this.fileHeadTitle);
            }
            return;
        }
        int headRow = 2;
        if (this.row <= headRow) {
            this.errorExcelImportDataVO.setExcelHeadTip(Lists.newArrayList(data.values()));
            return;
        }
        int dataSize = data.size();
        if ((long)dataSize == (emptySize = data.values().stream().filter(CharSequenceUtil::isEmpty).count())) {
            return;
        }
        HashMap newData = new HashMap(data.size());
        if (CollUtil.isNotEmpty(data)) {
            data.forEach((key, val) -> {
                String title;
                try {
                    title = this.fileHeadTitle.get((int)key);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ELSBootException(I18nUtil.translate("i18n_alert_CcmKNS_58e2005d", "\u5185\u5bb9\u683c\u5f0f\u9519\u8bef"));
                }
                newData.put(title, val);
            });
        }
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        StringBuilder primaryKey = new StringBuilder();
        boolean check = true;
        HashMap excelData = new HashMap();
        String busAccount = this.excelByConfigDTO != null && StringUtils.isNotBlank((CharSequence)this.excelByConfigDTO.getBusAccount()) ? this.excelByConfigDTO.getBusAccount() : TenantContext.getTenant();
        StringBuffer errorSb = new StringBuffer();
        for (ExcelDetail detail : this.excelDetailList) {
            Object obj;
            String val2;
            String columnCode = detail.getColumnCode();
            String importData = val2 = (String)newData.get(columnCode);
            if (StrUtil.isNotBlank((CharSequence)val2)) {
                if (ExcelDataTypeEnum.DICT.getCode().equals(detail.getDataType())) {
                    StringBuffer temVal = new StringBuffer("");
                    if (StrUtil.isNotBlank((CharSequence)val2) && val2.contains(",")) {
                        String[] split = val2.split(",");
                        for (int i = 0; i < split.length; ++i) {
                            String dictValue;
                            if (!StrUtil.isNotBlank((CharSequence)split[i]) || !StrUtil.isNotBlank((CharSequence)(dictValue = this.getDictValue(detail, split[i], busAccount)))) continue;
                            temVal.append(dictValue).append(",");
                        }
                    } else {
                        String dictValue = this.getDictValue(detail, val2, busAccount);
                        if (StringUtils.isNotBlank((CharSequence)dictValue)) {
                            temVal.append(dictValue);
                        }
                    }
                    if ((val2 = temVal.toString()).endsWith(",")) {
                        val2 = val2.substring(0, val2.length() - 1);
                    }
                    if (StrUtil.isBlank((CharSequence)val2)) {
                        String msg = I18nUtil.translate("", "${0}[${1}]\u4e0d\u5b58\u5728\u4e8e\u6570\u636e\u5b57\u5178\u7f16\u7801[${2}]\u8303\u56f4\u5185", detail.getColumnName(), importData, detail.getDataFormat());
                        errorSb.append(msg).append(";");
                        check = false;
                        excelData.put(columnCode, newData.get(columnCode));
                        continue;
                    }
                    dataMap.put(columnCode, val2);
                }
                if (ExcelDataTypeEnum.NUMBER.getCode().equals(detail.getDataType())) {
                    try {
                        Double dVal = Double.valueOf(val2);
                        BigDecimal bVal = BigDecimal.valueOf(dVal).setScale(4, 4);
                        dataMap.put(columnCode, bVal.stripTrailingZeros().toPlainString());
                    }
                    catch (NumberFormatException e) {
                        dataMap.put(detail.getColumnCode(), val2);
                    }
                } else {
                    dataMap.put(columnCode, val2);
                }
                if (ExcelDataTypeEnum.DATE.getCode().equals(detail.getDataType()) && !StringUtils.isEmpty((CharSequence)val2)) {
                    try {
                        DateTime date = DateUtil.parse((CharSequence)val2);
                        String dateStr = DateUtil.format((Date)date, (String)"yyyy-MM-dd");
                        dataMap.put(columnCode, dateStr);
                    }
                    catch (Exception e) {
                        dataMap.put(detail.getColumnCode(), val2);
                    }
                } else {
                    dataMap.put(columnCode, val2);
                }
                if (CommonConstant.STATUS_YES.equals(detail.getPrimaryKey())) {
                    primaryKey.append(val2).append(",");
                }
            } else if (CommonConstant.STATUS_YES.equals(detail.getRequired())) {
                String msg = I18nUtil.translate("i18n_alert_WWWWWWKlSJOWxOLV_21cd61c7", "[${0}]\u662f\u5fc5\u586b\u5b57\u6bb5\uff0c\u4e0d\u80fd\u4e3a\u7a7a", detail.getColumnName());
                errorSb.append(msg).append(";");
                check = false;
            }
            if ((null == (obj = dataMap.get(columnCode)) || "".equals(obj.toString()) || "null".equals(obj.toString())) && null != importData && obj != importData) {
                dataMap.put(columnCode, importData);
            }
            dataMap.putIfAbsent(columnCode, null);
            excelData.put(columnCode, newData.get(columnCode));
        }
        if (StrUtil.isNotBlank((CharSequence)primaryKey.toString())) {
            if (this.primaryMap.containsKey(primaryKey.toString())) {
                String msg = I18nUtil.translate("i18n_alert_WWWWWWLIIVB_47f1ecff", "[${0}]\u552f\u4e00\u952e\u91cd\u590d", primaryKey.toString());
                if (CharSequenceUtil.isBlank((CharSequence)this.excelBusinessOptType)) {
                    throw new ELSBootException(msg);
                }
                errorSb.append(msg).append(";");
                check = false;
            } else {
                this.primaryMap.put(primaryKey.toString(), CommonConstant.STATUS_YES);
            }
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)this.excelBusinessOptType) && !check) {
            excelData.put(this.errorStatus, I18nUtil.translate("i18n_field_LRc_18fb76f", "\u672a\u6267\u884c"));
            excelData.put(this.errorTitle, errorSb.toString());
            log.info(" #{} Excel\u5bfc\u5165\u5b58\u5728\u5f02\u5e38\u6570\u636e", (Object)this.excelBusinessOptType);
            this.errorExcelImportDataVO.getDataList().add(excelData);
            return;
        }
        if (dataMap.size() == 0) {
            return;
        }
        dataMap.put("els_account", TenantContext.getTenant());
        this.importDataList.add(dataMap);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.fileHeadTitle = null;
        RedisUtil redisUtil = SpringContextUtils.getBean(RedisUtil.class);
        ExcelImportDTO excelImportDTO = new ExcelImportDTO();
        excelImportDTO.setDataList(this.importDataList);
        excelImportDTO.setExcelDetailList(this.excelDetailList);
        excelImportDTO.setExcelBusinessOptType(this.excelBusinessOptType);
        excelImportDTO.setExcelBusinessOptTypeName(this.excelBusinessOptTypeName);
        excelImportDTO.setTotalCount(this.importDataList.size());
        if (CollUtil.isEmpty(this.importDataList)) {
            this.successCount = 0L;
            HashMap<String, Object> errorMap = new HashMap<String, Object>();
            errorMap.put("successCount", this.successCount);
            if (CharSequenceUtil.isNotBlank((CharSequence)this.excelBusinessOptType)) {
                String id = this.errorExcelGenerate(redisUtil);
                if (!this.errorExcelImportDataVO.getDataList().isEmpty()) {
                    this.errorExcelKey = id;
                    SpringContextUtils.getBean(ExcelGenerateRunner.class).immediateExec(id, this.excelDetailList, this.elsAccount);
                    this.failCount = this.errorExcelImportDataVO.getDataList().size();
                    errorMap.put("errorId", this.errorExcelKey);
                    errorMap.put("failCount", this.failCount);
                    excelImportDTO.setErrorExcelRunnerId(this.errorExcelKey);
                    redisUtil.set(this.dataKey, excelImportDTO);
                    return;
                }
                this.errorExcelKey = null;
            }
            throw new ELSBootException(I18nUtil.translate("i18n_alert_uNIrjWFxqjWVImSKuN_65704043", "\u5bfc\u5165\u6a21\u677f\u7684\u6570\u636e\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u5bfc\u5165"));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)this.excelBusinessOptType)) {
            this.errorExcelKey = this.errorExcelGenerate(redisUtil);
            excelImportDTO.setErrorExcelRunnerId(this.errorExcelKey);
        }
        if (StrUtil.isBlank((CharSequence)this.dataKey)) {
            if (CollectionUtil.isNotEmpty(this.otherSheetList)) {
                HashMap<String, List<Map<String, Object>>> otherMap = new HashMap<String, List<Map<String, Object>>>();
                otherMap.put("otherSheetList", this.otherSheetList);
                this.importDataList.add(otherMap);
            }
            log.info("#doAfterAllAnalysed \u5373\u5c06\u6267\u884c\u5bfc\u5165\u6570\u636e\u7684\u903b\u8f91");
            excelImportDTO.setExcelByConfigDTO(this.excelByConfigDTO);
            excelImportDTO.setOtherRequestParam(this.otherRequestParam);
            this.importDataList = this.service.importExcel(excelImportDTO);
            if (StrUtil.isNotBlank((CharSequence)excelImportDTO.getInterfaceMsg())) {
                this.interfaceMsg = excelImportDTO.getInterfaceMsg();
            }
            if (CharSequenceUtil.isNotBlank((CharSequence)this.excelBusinessOptType) && CharSequenceUtil.isNotBlank((CharSequence)this.errorExcelKey)) {
                String key = ExcelRedisKeyGenerateUtil.generateImportKey(this.excelBusinessOptType, TenantContext.getTenant(), this.errorExcelKey);
                long mapLen = redisUtil.mapLen(key);
                if (mapLen > 2L) {
                    this.failCount = mapLen - 2L;
                    SpringContextUtils.getBean(ExcelGenerateRunner.class).immediateExec(this.errorExcelKey, this.excelDetailList, this.elsAccount);
                } else {
                    SpringContextUtils.getBean(BackgroundFileTaskService.class).deleteFileTask(this.errorExcelKey);
                    this.errorExcelKey = null;
                }
            }
            this.successCount = Long.parseLong(String.valueOf(ObjectUtil.defaultIfNull((Object)redisUtil.get(ExcelRedisKeyGenerateUtil.generateImportSuccessCountKey(this.excelBusinessOptType, excelImportDTO.getErrorExcelRunnerId())), (Object)0)));
        } else {
            log.info("doAfterAllAnalysed save importDataList to redis key:{}", (Object)this.dataKey);
            redisUtil.set(this.dataKey, excelImportDTO);
        }
    }

    private String errorExcelGenerate(RedisUtil redisUtil) {
        String idKey = IdWorker.getIdStr();
        String key = ExcelRedisKeyGenerateUtil.generateImportKey(this.excelBusinessOptType, TenantContext.getTenant(), idKey);
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        result.put("title", this.errorExcelImportDataVO.getExcelHead());
        result.put("titleTip", this.errorExcelImportDataVO.getExcelHeadTip());
        for (int i = 0; i < this.errorExcelImportDataVO.getDataList().size(); ++i) {
            result.put(String.valueOf(i), this.errorExcelImportDataVO.getDataList().get(i));
        }
        redisUtil.hmset(key, result, 259200L);
        String templateListKey = ExcelRedisKeyGenerateUtil.generateImportDetailKey(this.excelBusinessOptType, idKey);
        redisUtil.set(templateListKey, this.excelDetailList, 260200L);
        if (this.errorExcelImportDataVO.getDataList().size() > 0) {
            log.info("#errorExcelGenerate  \u5bfc\u5165\u6a21\u677f\u6821\u9a8c\u65f6\u5019\u5b58\u5728\u9519\u8bef\u6570\u636e\uff0c\u4fdd\u5b58\u9519\u8bef\u8bb0\u5f55");
            BackgroundFileTaskService taskService = SpringContextUtils.getBean(BackgroundFileTaskService.class);
            taskService.saveImportTask(this.excelBusinessOptType, this.excelBusinessOptTypeName, idKey, TenantContext.getTenant());
        }
        return idKey;
    }

    public String getErrorExcelKey() {
        return this.errorExcelKey;
    }

    public String getInterfaceMsg() {
        return this.interfaceMsg;
    }

    public long getSuccessCount() {
        return this.successCount;
    }

    public long getFailCount() {
        return this.failCount;
    }
}

