/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.vo.DictModel;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SqlInjectionUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.BackgroundFileTask;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.modules.system.enums.TaskStatusEnum;
import com.els.modules.system.service.BackgroundFileTaskService;
import com.els.modules.system.service.impl.DictServiceImpl;
import com.els.modules.system.util.ExcelErrorExportStyle;
import com.els.modules.system.util.ExcelHeaderUtil;
import com.els.modules.system.util.ExcelRedisKeyGenerateUtil;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class ExcelGenerateRunner {
    private static final Logger log = LoggerFactory.getLogger(ExcelGenerateRunner.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private BackgroundFileTaskService backgroundFileTaskService;
    private static final String UPLOAD_PATH = SpringContextUtils.getBean(Environment.class).getProperty("els.path.upload");
    private static final String SERVICE_ADDRESS = SpringContextUtils.getBean(Environment.class).getProperty("els.config.service.address");
    private static final String NGINX_PATH = "/opt/upFiles";

    public void immediateExec(String id, List<ExcelDetail> detailList, String elsAccount) {
        String busAccount = StringUtils.isBlank((CharSequence)elsAccount) ? TenantContext.getTenant() : elsAccount;
        BackgroundFileTask task = (BackgroundFileTask)this.backgroundFileTaskService.getById((Serializable)((Object)id));
        String key = ExcelRedisKeyGenerateUtil.generateImportKey(task.getTaskOptBusinessType(), task.getElsAccount(), id);
        Map<Object, Object> resultData = this.redisUtil.hmget(key);
        List titleList = (List)resultData.remove("title");
        List titleTipList = (List)resultData.remove("titleTip");
        if (resultData.size() == 0) {
            log.info("#immediateExec \u65e0\u53ef\u5bfc\u51fa\u7684\u5f02\u5e38\u6570\u636e");
            task.setErrorMessage("no data");
            task.setTaskStatus(TaskStatusEnum.FAIL.getCode());
            Integer failTimes = (Integer)ObjectUtil.defaultIfNull((Object)task.getFailTimes(), (Object)0);
            task.setFailTimes(failTimes + 1);
            if (task.getFailTimes() > 1) {
                this.backgroundFileTaskService.removeById((Serializable)((Object)task.getId()));
            } else {
                this.backgroundFileTaskService.updateById(task);
            }
            return;
        }
        TreeMap data = resultData.entrySet().stream().sorted(Comparator.comparing(x -> Integer.parseInt(String.valueOf(x.getKey())))).collect(Collectors.toMap(Map.Entry::getKey, val -> {
            Map m = (Map)val.getValue();
            Set mapKey = m.keySet();
            Map temMap = titleList.stream().filter(x -> !mapKey.contains(x)).collect(Collectors.toMap(Function.identity(), x -> ""));
            if (!temMap.isEmpty()) {
                m.putAll(temMap);
            }
            return m;
        }, (k1, k2) -> k1, TreeMap::new));
        if (CollUtil.isEmpty(detailList)) {
            String templateListKey = ExcelRedisKeyGenerateUtil.generateImportDetailKey(task.getTaskOptBusinessType(), id);
            detailList = (List)this.redisUtil.get(templateListKey);
        }
        if (CollUtil.isEmpty(detailList)) {
            log.info("#immediateExec Excel\u6570\u636e\u5df2\u8fc7\u671f");
            task.setErrorMessage("Excel\u6570\u636e\u5df2\u8fc7\u671f");
            task.setTaskStatus(TaskStatusEnum.FAIL.getCode());
            Integer failTimes = (Integer)ObjectUtil.defaultIfNull((Object)task.getFailTimes(), (Object)0);
            task.setFailTimes(failTimes);
            this.backgroundFileTaskService.updateById(task);
            return;
        }
        Map excelDetailMap = detailList.stream().filter(x -> x.getDataType().equals(ExcelDataTypeEnum.DICT.getCode())).collect(Collectors.toMap(ExcelDetail::getColumnCode, Function.identity()));
        String documentLocation = File.separator + "errorExcel" + File.separator + task.getElsAccount() + File.separator + task.getTaskName() + "_" + System.currentTimeMillis() + ".xlsx";
        File file = new File(this.loadSavePath(documentLocation));
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ArrayList list = Lists.newArrayList(data.values());
            ArrayList dataList = new ArrayList();
            for (Object o : list) {
                HashMap map = (HashMap)JSONObject.parseObject((String)JSONObject.toJSONString(o), HashMap.class);
                ArrayList<String> dataList1 = new ArrayList<String>();
                String toElsAccount = map.containsKey("toElsAccount") ? (String)map.get("toElsAccount") : null;
                for (String s : titleList) {
                    if (map.containsKey(s)) {
                        ExcelDetail excelDetail = (ExcelDetail)excelDetailMap.get(s);
                        if (excelDetail != null) {
                            String dictCode = excelDetail.getDataFormat();
                            String text = this.dictTranslate(dictCode, (String)map.get(s), busAccount, toElsAccount);
                            if (text != null) {
                                dataList1.add(text);
                                continue;
                            }
                            dataList1.add((String)map.get(s));
                            continue;
                        }
                        dataList1.add((String)map.get(s));
                        continue;
                    }
                    dataList1.add("");
                }
                dataList.add(dataList1);
            }
            EasyExcel.write((OutputStream)fileOutputStream).registerWriteHandler((WriteHandler)new ExcelErrorExportStyle(detailList)).head(ExcelHeaderUtil.getErrorHeaderList(titleList, titleTipList)).sheet("data").doWrite(dataList);
            task.setTaskStatus(TaskStatusEnum.SUCCESS.getCode());
            task.setTaskFilePath(documentLocation);
            task.setExpirationTime((Date)DateUtil.offsetDay((Date)new Date(), (int)3));
            this.backgroundFileTaskService.updateById(task);
        }
        catch (Exception e) {
            log.info("...#ExcelGenerateRunner#immediateExec \u751f\u6210\u9519\u8befExcel\u6570\u636e\u8868\u5f02\u5e38:{}", (Object)e.getMessage());
            Integer failTimes = (Integer)ObjectUtil.defaultIfNull((Object)task.getFailTimes(), (Object)0);
            task.setFailTimes(failTimes + 1);
            task.setTaskStatus(TaskStatusEnum.FAIL.getCode());
            task.setErrorMessage(e.getMessage());
            if (task.getFailTimes() >= 3) {
                this.backgroundFileTaskService.removeById((Serializable)((Object)task.getId()));
            }
            this.backgroundFileTaskService.updateById(task);
        }
    }

    private String loadDownloadPath(String objectPath) {
        if (objectPath.startsWith(File.separator) && UPLOAD_PATH.endsWith(File.separator)) {
            objectPath = objectPath.substring(1);
        }
        String url = SERVICE_ADDRESS + NGINX_PATH + objectPath;
        return url.replace("\\", "/");
    }

    private String loadSavePath(String objectPath) {
        if (objectPath.startsWith(File.separator) && UPLOAD_PATH.endsWith(File.separator)) {
            objectPath = objectPath.substring(1);
        }
        String url = UPLOAD_PATH + objectPath;
        return url.replace("\\", "/");
    }

    public String dictTranslate(String dictCode, String value, String busAccount, String toElsAccount) {
        List<DictModel> dictList = null;
        if (dictCode.contains("#") || dictCode.contains(",")) {
            String[] params = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
            if (params.length != 4) {
                return null;
            }
            String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
            SqlInjectionUtil.filterContent(sqlInjCheck);
            String filterSql = params[3];
            SqlInjectionUtil.filterContent(filterSql);
            dictList = SpringContextUtils.getBean(DictServiceImpl.class).queryTableDictListByFilterSql(busAccount, params[0], params[1], params[2], filterSql);
            if (CollUtil.isEmpty(dictList) && toElsAccount != null) {
                dictList = SpringContextUtils.getBean(DictServiceImpl.class).queryTableDictListByFilterSql(toElsAccount, params[0], params[1], params[2], filterSql);
            }
        } else {
            dictList = SpringContextUtils.getBean(DictServiceImpl.class).queryDictItemsByCode(dictCode, busAccount);
        }
        if (dictList.size() > 0) {
            for (DictModel dictModel : dictList) {
                if (!dictModel.getValue().equals(value)) continue;
                return dictModel.getText();
            }
            return null;
        }
        return null;
    }
}

