/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ColumnDefine;
import com.els.modules.system.entity.I18n;
import com.els.modules.system.service.ColumnDefineService;
import com.els.modules.system.service.I18nService;
import com.els.modules.system.util.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217"})
@RestController
@RequestMapping(value={"/columnDefine"})
public class ColumnDefineController
extends BaseController<ColumnDefine, ColumnDefineService> {
    @Autowired
    private ColumnDefineService columnDefineService;
    @Autowired
    private I18nService i18nService;

    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ColumnDefine columnDefine, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<ColumnDefine> queryWrapper = QueryGenerator.initQueryWrapper(columnDefine, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.orderByAsc((Object)"sort_order");
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.columnDefineService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6839\u636etableCode\u67e5\u8be2", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6839\u636etableCode\u67e5\u8be2")
    @GetMapping(value={"/listByTableCode"})
    public Result<?> queryListByTableCode(ColumnDefine columnDefine, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        if (StringUtils.isBlank((String)columnDefine.getTableCode())) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_BmAosWxOLVW_14e2f884", "\u8868\u683c\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!"));
        }
        QueryWrapper<ColumnDefine> queryWrapper = QueryGenerator.initQueryWrapper(columnDefine, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.orderByAsc((Object)"sort_order");
        IPage pageList = this.columnDefineService.page((IPage)page, (Wrapper)queryWrapper);
        if (pageList.getRecords().isEmpty()) {
            TenantContext.setTenant("100000");
            queryWrapper = QueryGenerator.initQueryWrapper(columnDefine, req.getParameterMap());
            pageList = this.columnDefineService.page((IPage)page, (Wrapper)queryWrapper);
            if (pageList.getRecords().isEmpty()) {
                throw new ELSBootException(I18nUtil.translate("i18n_alert_LYuAEtHetAJIIVHW_1c2e4ea3", "\u672a\u627e\u5230\u4f01\u4e1a\u53ca\u7cfb\u7edf\u7ea7\u5217\u81ea\u5b9a\u4e49\u4fe1\u606f!"));
            }
        }
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u901a\u8fc7tableCode\u67e5\u8be2(\u9ad8\u7ea7\u67e5\u8be2\u4f7f\u7528)", notes="\u901a\u8fc7tableCode\u67e5\u8be2(\u9ad8\u7ea7\u67e5\u8be2\u4f7f\u7528)")
    @GetMapping(value={"/queryListByTableCode"})
    public Result<?> queryListByTableCode(@RequestParam(name="tableCode", required=true) String tableCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"table_code", (Object)tableCode);
        queryWrapper.orderByAsc((Object)"sort_order");
        List defineList = this.columnDefineService.list((Wrapper)queryWrapper);
        if (defineList.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            queryWrapper.eq((Object)"table_code", (Object)tableCode);
            queryWrapper.orderByAsc((Object)"sort_order");
            defineList = this.columnDefineService.list((Wrapper)queryWrapper);
        }
        JSONArray result = new JSONArray();
        for (ColumnDefine define : defineList) {
            JSONObject object = new JSONObject();
            object.put("fieldCode", (Object)define.getColumnCode().split("_")[0]);
            object.put("fieldName", (Object)define.getColumnName());
            object.put("fieldType", (Object)(StrUtil.isBlank((CharSequence)define.getFieldType()) ? "input" : define.getFieldType()));
            object.put("dictCode", (Object)define.getDictCode());
            object.put("columnNameI18nKey", (Object)define.getColumnNameI18nKey());
            result.add((Object)object);
        }
        return Result.ok(result);
    }

    @ApiOperation(value="100000\u53f7\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="100000\u53f7\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/sysList"})
    public Result<?> querySysPageList(ColumnDefine columnDefine, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        TenantContext.setTenant("100000");
        QueryWrapper<ColumnDefine> queryWrapper = QueryGenerator.initQueryWrapper(columnDefine, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.orderByAsc((Object)"sort_order");
        IPage pageList = this.columnDefineService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @AutoLog(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6dfb\u52a0", logType=2, operateType=2)
    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6dfb\u52a0", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ColumnDefine columnDefine) {
        if (StringUtils.isBlank((String)columnDefine.getColumnNameI18nKey())) {
            String s = this.i18nService.checkAndAdd(columnDefine.getColumnName(), "field");
            columnDefine.setColumnNameI18nKey(s);
        }
        this.columnDefineService.save(columnDefine);
        return this.commonSuccessResult(2);
    }

    @AutoLog(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u7f16\u8f91", logType=2, operateType=3)
    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u7f16\u8f91", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ColumnDefine columnDefine) {
        if (StringUtils.isBlank((String)columnDefine.getColumnNameI18nKey())) {
            String s = this.i18nService.checkAndAdd(columnDefine.getColumnName(), "field");
            columnDefine.setColumnNameI18nKey(s);
        }
        this.columnDefineService.updateById(columnDefine);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u5220\u9664", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.columnDefineService.removeById((Serializable)((Object)id));
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6279\u91cf\u5220\u9664", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.columnDefineService.removeByIds(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u67e5\u8be2", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ColumnDefine columnDefine = (ColumnDefine)this.columnDefineService.getById((Serializable)((Object)id));
        return Result.ok(columnDefine);
    }

    @AutoLog(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u5bfc\u51faExcel", logType=2, operateType=6)
    @RequestMapping(value={"/exportXls"}, method={RequestMethod.GET})
    public ModelAndView exportXls(HttpServletRequest request, ColumnDefine columnDefine) {
        return super.exportXls(request, columnDefine, ColumnDefine.class, "\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217");
    }

    @AutoLog(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u5bfc\u5165Excel", logType=2, operateType=5)
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ColumnDefine.class);
    }

    private String checkDelete(String value) {
        return "success";
    }

    private String checkExist(String dataId, String value) {
        return "success";
    }

    @AutoLog(value="\u6279\u91cf\u751f\u6210\u56fd\u9645\u5316Key", logType=2, operateType=3)
    @ApiOperation(value="\u6279\u91cf\u751f\u6210\u56fd\u9645\u5316Key", notes="\u6279\u91cf\u751f\u6210\u56fd\u9645\u5316Key")
    @PostMapping(value={"/addBatchKey"})
    public Result<?> addBatchKey(@RequestBody HashMap<String, String> data) {
        String temIds = data.get("temIds");
        List<String> idList = Arrays.asList(temIds.split(","));
        Assert.isTrue((!CollectionUtil.isEmpty(idList) ? 1 : 0) != 0, (String)I18nUtil.translate("i18n_field_VRRiFIAHcbLW_eb724e13", "\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u5217\u8fdb\u884c\u751f\u6210\uff01"));
        List columnDefineList = this.columnDefineService.listByIds(idList);
        List collect = columnDefineList.parallelStream().filter(item -> org.apache.commons.lang3.StringUtils.isBlank((CharSequence)item.getColumnNameI18nKey())).map(item -> item.getColumnName()).collect(Collectors.toList());
        Map<Object, Object> stringMap = new HashMap();
        if (!CollectionUtils.isEmpty(collect)) {
            List zh = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.i18nService.lambdaQuery().eq(I18n::getLanguage, (Object)"zh")).in(I18n::getI18nValue, collect)).list();
            stringMap = zh.stream().collect(Collectors.toMap(I18n::getI18nValue, I18n::getI18nKey, (key1, key2) -> key2));
        }
        HashMap<String, String> noKeyHashMap = new HashMap<String, String>();
        for (ColumnDefine entity : columnDefineList) {
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)entity.getColumnNameI18nKey())) continue;
            if (stringMap.containsKey(entity.getColumnName())) {
                entity.setColumnNameI18nKey((String)stringMap.get(entity.getColumnName()));
                continue;
            }
            String field = this.i18nService.createI18nKey(entity.getColumnName(), "field");
            noKeyHashMap.put(entity.getColumnName(), field);
            entity.setColumnNameI18nKey(field);
        }
        if (!columnDefineList.isEmpty()) {
            this.columnDefineService.updateBatchById(columnDefineList);
        }
        this.i18nService.addOtherKey(noKeyHashMap);
        this.i18nService.delRedisData();
        return this.commonSuccessResult(3);
    }
}

