/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.util.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.PutObjectResult;
import java.io.IOException;
import java.util.UUID;
import org.apache.tomcat.util.http.fileupload.FileItemStream;
import org.springframework.web.multipart.MultipartFile;

public class OssBootUtil {
    private static String endPoint;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String bucketName;
    private static String staticDomain;
    private static OSSClient ossClient;
    private static String FILE_URL;

    public static void setEndPoint(String endPoint) {
        OssBootUtil.endPoint = endPoint;
    }

    public static void setAccessKeyId(String accessKeyId) {
        OssBootUtil.accessKeyId = accessKeyId;
    }

    public static void setAccessKeySecret(String accessKeySecret) {
        OssBootUtil.accessKeySecret = accessKeySecret;
    }

    public static void setBucketName(String bucketName) {
        OssBootUtil.bucketName = bucketName;
    }

    public static void setStaticDomain(String staticDomain) {
        OssBootUtil.staticDomain = staticDomain;
    }

    public static String upload(MultipartFile file, String fileDir) {
        OssBootUtil.initOSS(endPoint, accessKeyId, accessKeySecret);
        StringBuilder fileUrl = new StringBuilder();
        try {
            String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(46));
            String fileName = UUID.randomUUID().toString().replace("-", "") + suffix;
            if (!fileDir.endsWith("/")) {
                fileDir = fileDir.concat("/");
            }
            fileUrl = fileUrl.append(fileDir + fileName);
            FILE_URL = "https://" + bucketName + "." + endPoint + "/" + fileUrl;
            PutObjectResult result = ossClient.putObject(bucketName, fileUrl.toString(), file.getInputStream());
            ossClient.setBucketAcl(bucketName, CannedAccessControlList.PublicRead);
            if (result != null) {
                System.out.println("------OSS\u6587\u4ef6\u4e0a\u4f20\u6210\u529f------" + fileUrl);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return FILE_URL;
    }

    public static String upload(FileItemStream file, String fileDir) {
        OssBootUtil.initOSS(endPoint, accessKeyId, accessKeySecret);
        StringBuilder fileUrl = new StringBuilder();
        try {
            String suffix = file.getName().substring(file.getName().lastIndexOf(46));
            String fileName = UUID.randomUUID().toString().replace("-", "") + suffix;
            if (!fileDir.endsWith("/")) {
                fileDir = fileDir.concat("/");
            }
            fileUrl = fileUrl.append(fileDir + fileName);
            FILE_URL = "https://" + bucketName + "." + endPoint + "/" + fileUrl;
            PutObjectResult result = ossClient.putObject(bucketName, fileUrl.toString(), file.openStream());
            ossClient.setBucketAcl(bucketName, CannedAccessControlList.PublicRead);
            if (result != null) {
                System.out.println("------OSS\u6587\u4ef6\u4e0a\u4f20\u6210\u529f------" + fileUrl);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return FILE_URL;
    }

    public static void deleteUrl(String url) {
        String bucketUrl = "https://" + bucketName + "." + endPoint + "/";
        url = url.replace(bucketUrl, "");
        ossClient.deleteObject(bucketName, url);
    }

    public static void delete(String fileName) {
        ossClient.deleteObject(bucketName, fileName);
    }

    private static OSSClient initOSS(String endpoint, String accessKeyId, String accessKeySecret) {
        if (ossClient == null) {
            ossClient = new OSSClient(endpoint, (CredentialsProvider)new DefaultCredentialProvider(accessKeyId, accessKeySecret), new ClientConfiguration());
        }
        return ossClient;
    }

    static {
        ossClient = null;
    }
}

