/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.async;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AsyncThreadConfig {
    @Bean(value={"srmPoolExecutor"})
    public ThreadPoolExecutor srmPoolExecutor() {
        return new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 5, Runtime.getRuntime().availableProcessors() * 40, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), new NameTreadFactory());
    }

    static class NameTreadFactory
    implements ThreadFactory {
        private final AtomicInteger mThreadNum = new AtomicInteger(1);

        NameTreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "My-Async-Thread-" + this.mThreadNum.getAndIncrement());
        }
    }
}

