/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.groovy;

import com.els.common.service.EnhanceService;
import groovy.lang.GroovyClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhanceGroovyFactory {
    private static final Logger log = LoggerFactory.getLogger(EnhanceGroovyFactory.class);
    private static EnhanceGroovyFactory groovyFactory = new EnhanceGroovyFactory();
    private GroovyClassLoader groovyClassLoader = new GroovyClassLoader();

    public static EnhanceGroovyFactory getInstance() {
        return groovyFactory;
    }

    private EnhanceGroovyFactory() {
    }

    public EnhanceService getEnhanceServiceFromCode(String code) {
        try {
            Object instance;
            Class clazz = this.groovyClassLoader.parseClass(code);
            if (clazz != null && (instance = clazz.newInstance()) != null && instance instanceof EnhanceService) {
                return (EnhanceService)instance;
            }
            return null;
        }
        catch (Exception e) {
            log.error("getEnhanceServiceFromCode failed:" + code, (Throwable)e);
            return null;
        }
    }
}

