/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.system.query;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.aspect.annotation.KeyWord;
import com.els.common.system.query.QueryCondition;
import com.els.common.system.query.enumerate.MatchTypeEnum;
import com.els.common.system.query.enumerate.QueryRuleEnum;
import com.els.common.util.ConvertUtils;
import com.els.common.util.DateUtils;
import com.els.common.util.SqlInjectionUtil;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.util.AdminFlagUtil;
import com.els.modules.system.util.PermissionDataUtil;
import com.els.modules.system.util.PermissionFlagUtil;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryGenerator {
    private static final Logger log = LoggerFactory.getLogger(QueryGenerator.class);
    private static final String BEGIN = "_begin";
    private static final String END = "_end";
    private static final String STAR = "*";
    private static final String COMMA = ",";
    private static final String NOT_EQUAL = "!";
    private static final String QUERY_SEPARATE_KEYWORD = " ";
    private static final String SUPER_QUERY_PARAMS = "superQueryParams";
    private static final String SUPER_QUERY_MATCH_TYPE = "superQueryMatchType";
    private static final String ORDER_COLUMN = "column";
    private static final String FILTER_COLUMN = "filter";
    private static final String KEY_WORD_COLUMN = "keyWord";
    private static final String QUERY_ID = "queryId";
    private static final String ORDER_TYPE = "order";
    private static final String ORDER_TYPE_ASC = "ASC";
    private static final String ORDER_TYPE_DESC = "DESC";
    private static final ThreadLocal<SimpleDateFormat> LOCAL = new ThreadLocal();

    private static SimpleDateFormat getTime() {
        SimpleDateFormat time = LOCAL.get();
        if (time == null) {
            time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            LOCAL.set(time);
        }
        return time;
    }

    private static void removeTime() {
        LOCAL.remove();
    }

    public static <T> QueryWrapper<T> initQueryWrapper(T searchObj, Map<String, String[]> parameterMap) {
        long start = System.currentTimeMillis();
        QueryWrapper queryWrapper = new QueryWrapper();
        QueryGenerator.installMplus(queryWrapper, searchObj, parameterMap);
        log.info("---\u67e5\u8be2\u6761\u4ef6\u6784\u9020\u5668\u521d\u59cb\u5316\u5b8c\u6210,\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2----");
        return queryWrapper;
    }

    private static Map<String, List<String>> getPermissionMap() {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        List<PermissionData> dataList = PermissionDataUtil.getData();
        if (dataList == null || dataList.isEmpty()) {
            return resultMap;
        }
        Map<String, List<PermissionData>> map = dataList.parallelStream().collect(Collectors.groupingBy(PermissionData::getPermissionField));
        for (String key : map.keySet()) {
            List<PermissionData> list = map.get(key);
            List values = list.stream().map(PermissionData::getPermissionValue).collect(Collectors.toList());
            resultMap.put(key, values);
        }
        PermissionDataUtil.clear();
        return resultMap;
    }

    private static void installMplus(QueryWrapper<?> queryWrapper, Object searchObj, Map<String, String[]> parameterMap) {
        List lstFields = QueryGenerator.getClassAllField(searchObj.getClass());
        Map<String, List<String>> dataRuleMap = QueryGenerator.getPermissionMap();
        HashMap fieldColumnMap = Maps.newHashMap();
        String keyWord = "";
        boolean dataRuleFlag = true;
        String adminFlag = AdminFlagUtil.getAdminFlag();
        String permissionFlag = PermissionFlagUtil.getPermissionFlag();
        PermissionFlagUtil.clear();
        if (parameterMap.containsKey(KEY_WORD_COLUMN)) {
            keyWord = parameterMap.get(KEY_WORD_COLUMN)[0];
        }
        ArrayList<String> keyWordFields = new ArrayList<String>(16);
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (Field lstField : lstFields) {
            String name;
            String queryName = name = lstField.getName();
            String talbeFieldName = null;
            String type = lstField.getType().toString();
            TableField objAnnotation = lstField.getAnnotation(TableField.class);
            if (objAnnotation != null && !objAnnotation.exist()) continue;
            if (objAnnotation != null) {
                talbeFieldName = objAnnotation.value();
                fieldMap.put(name, talbeFieldName);
                if (StringUtils.isNotBlank((CharSequence)talbeFieldName) && (talbeFieldName = talbeFieldName.toLowerCase()).indexOf("is") == 0) {
                    queryName = talbeFieldName;
                    fieldColumnMap.put(name, queryName);
                }
            }
            try {
                Object value;
                if (QueryGenerator.judgedIsUselessField(name) || !PropertyUtils.isReadable((Object)searchObj, (String)name)) continue;
                boolean isKeyWord = false;
                if (lstField.getAnnotation(KeyWord.class) != null) {
                    keyWordFields.add(name);
                    isKeyWord = true;
                }
                if (dataRuleMap.containsKey(name) && !"1".equals(adminFlag) && "1".equals(permissionFlag)) {
                    List<String> values = dataRuleMap.get(name);
                    values.add("");
                    String filedName = talbeFieldName;
                    queryWrapper.and(q -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)q.isNull((Object)filedName)).or()).in((Object)filedName, (Collection)values);
                    });
                    dataRuleFlag = false;
                }
                if (parameterMap != null && parameterMap.containsKey(name + BEGIN)) {
                    String beginValue = parameterMap.get(name + BEGIN)[0].trim();
                    QueryGenerator.addQueryByRule(queryWrapper, queryName, type, beginValue, QueryRuleEnum.GE);
                }
                if (parameterMap != null && parameterMap.containsKey(name + END)) {
                    String endValue = parameterMap.get(name + END)[0].trim();
                    QueryGenerator.addQueryByRule(queryWrapper, queryName, type, endValue, QueryRuleEnum.LE);
                }
                if (null != (value = PropertyUtils.getSimpleProperty((Object)searchObj, (String)name)) && value.toString().startsWith(COMMA) && value.toString().endsWith(COMMA)) {
                    String multiLikeval = value.toString().replace(",,", COMMA);
                    String[] vals = multiLikeval.substring(1).split(COMMA);
                    String field = ConvertUtils.camelToUnderline(queryName);
                    if (vals.length > 1) {
                        queryWrapper.and(j -> {
                            j = (QueryWrapper)j.like((Object)field, (Object)vals[0]);
                            for (int k = 1; k < vals.length; ++k) {
                                j = (QueryWrapper)((QueryWrapper)j.or()).like((Object)field, (Object)vals[k]);
                            }
                        });
                        continue;
                    }
                    queryWrapper.and(j -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)j.like((Object)field, (Object)vals[0]);
                    });
                    continue;
                }
                QueryRuleEnum rule = QueryGenerator.convert2Rule(value);
                value = QueryGenerator.replaceValue(rule, value);
                if (isKeyWord && (rule == null || QueryRuleEnum.EQ.equals((Object)rule)) && "class java.lang.String".equals(type)) {
                    rule = QueryRuleEnum.LIKE;
                }
                QueryGenerator.addEasyQuery(queryWrapper, queryName, rule, value);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        log.info("dataRuleFlag === " + dataRuleFlag);
        log.info("adminFlag === " + adminFlag);
        log.info("permissionFlag === " + permissionFlag);
        if (dataRuleFlag && !"1".equals(adminFlag) && "1".equals(permissionFlag)) {
            queryWrapper.eq((Object)"1", (Object)2);
        }
        QueryGenerator.doMultiFieldsOrder(queryWrapper, parameterMap, searchObj);
        QueryGenerator.doMultiFieldsFilter(queryWrapper, parameterMap, fieldMap);
        QueryGenerator.doSuperQuery(queryWrapper, parameterMap, fieldColumnMap);
        QueryGenerator.doKeyWordQuery(queryWrapper, keyWordFields, keyWord);
    }

    private static List getClassAllField(Class objClass) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (objClass != null && !objClass.getName().toLowerCase().equals("java.lang.object")) {
            fieldList.addAll(Arrays.asList(objClass.getDeclaredFields()));
            objClass = objClass.getSuperclass();
        }
        return fieldList;
    }

    private static void doKeyWordQuery(QueryWrapper<?> queryWrapper, List<String> keyWordFields, String keyWord) {
        if (StringUtils.isNotBlank((CharSequence)keyWord) && keyWordFields.size() > 0) {
            StringBuilder column = new StringBuilder("concat(");
            for (int index = 0; index < keyWordFields.size(); ++index) {
                column.append("ifnull(").append(ConvertUtils.camelToUnderline(keyWordFields.get(index))).append(",'')");
                if (index == keyWordFields.size() - 1) continue;
                column.append(COMMA);
            }
            column.append(")");
            queryWrapper.like((Object)column.toString(), (Object)keyWord);
        }
    }

    private static void doMultiFieldsFilter(QueryWrapper<?> queryWrapper, Map<String, String[]> parameterMap, Map<String, String> fieldMap) {
        if (parameterMap != null && parameterMap.containsKey(FILTER_COLUMN)) {
            String filter = parameterMap.get(FILTER_COLUMN)[0];
            JSONObject json = JSONObject.parseObject((String)filter);
            for (String key : json.keySet()) {
                String talbeFieldName;
                if (!StringUtils.isNotBlank((CharSequence)json.getString(key))) continue;
                List<String> valueList = Arrays.asList(json.getString(key).split(COMMA));
                String column = key;
                if (column.endsWith("_dictText")) {
                    column = key.substring(0, key.lastIndexOf("_dictText"));
                }
                if (StrUtil.isNotBlank((CharSequence)(talbeFieldName = fieldMap.get(column))) && talbeFieldName.indexOf("is") == 0) {
                    column = talbeFieldName;
                }
                SqlInjectionUtil.filterContent(column);
                queryWrapper.in((Object)ConvertUtils.camelToUnderline(column), valueList);
            }
        }
    }

    public static void doMultiFieldsOrder(QueryWrapper<?> queryWrapper, Map<String, String[]> parameterMap, Object searchObj) {
        String column = null;
        String order = null;
        if (parameterMap != null && parameterMap.containsKey(ORDER_COLUMN)) {
            column = parameterMap.get(ORDER_COLUMN)[0];
        }
        if (parameterMap != null && parameterMap.containsKey(ORDER_TYPE)) {
            order = parameterMap.get(ORDER_TYPE)[0];
        }
        if (null == column) {
            return;
        }
        if (column.split(COMMA).length > 1 || StrUtil.isNotBlank((CharSequence)order) && order.split(COMMA).length > 1) {
            QueryGenerator.doMultiFieldsOrderOfSplitWithComma(queryWrapper, column, order, searchObj);
            return;
        }
        log.debug("\u6392\u5e8f\u89c4\u5219>>\u5217:" + column + ",\u6392\u5e8f\u65b9\u5f0f:" + order);
        if (ConvertUtils.isNotEmpty(column) && ConvertUtils.isNotEmpty(order)) {
            QueryGenerator.setOrderColumn(queryWrapper, column, order, searchObj);
        }
    }

    private static void doMultiFieldsOrderOfSplitWithComma(QueryWrapper<?> queryWrapper, String column, String order, Object searchObj) {
        int i;
        log.debug("\u6392\u5e8f\u89c4\u5219>>\u5217:" + column + ",\u6392\u5e8f\u65b9\u5f0f:" + order);
        order = StrUtil.blankToDefault((CharSequence)order, (String)ORDER_TYPE_DESC);
        String[] orderColumns = column.split(COMMA);
        String[] orderTypes = new String[orderColumns.length];
        String[] splitOrderType = order.split(COMMA);
        String temType = splitOrderType.length > 0 && splitOrderType.length < orderColumns.length ? splitOrderType[0] : null;
        for (i = 0; i < splitOrderType.length && i < orderColumns.length; ++i) {
            orderTypes[i] = splitOrderType[i];
        }
        for (i = 0; i < orderColumns.length; ++i) {
            if (!ConvertUtils.isNotEmpty(orderColumns[i])) continue;
            String orderType = orderTypes[i];
            orderType = StrUtil.isBlank((CharSequence)orderType) ? temType : orderType;
            QueryGenerator.setOrderColumn(queryWrapper, orderColumns[i], StrUtil.blankToDefault((CharSequence)orderType, (String)ORDER_TYPE_ASC), searchObj);
        }
    }

    private static void setOrderColumn(QueryWrapper<?> queryWrapper, String column, String order, Object searchObj) {
        if (column.endsWith("_dictText")) {
            column = column.substring(0, column.lastIndexOf("_dictText"));
        }
        SqlInjectionUtil.filterContent(column);
        String tableFiled = QueryGenerator.getTableFiled(column, queryWrapper, searchObj.getClass());
        if (order.toUpperCase().contains(ORDER_TYPE_ASC)) {
            queryWrapper.orderByAsc((Object)tableFiled);
        } else {
            queryWrapper.orderByDesc((Object)tableFiled);
        }
    }

    private static String getTableFiled(String column, QueryWrapper<?> queryWrapper, Class<?> clazz) {
        String value;
        String entityColumn = QueryGenerator.initialToCapital(column);
        QueryGenerator.getClassAllField(clazz);
        Field field = QueryGenerator.getClassField(clazz, entityColumn);
        if (null == field) {
            log.error("::: \u5b9e\u4f53\u6ca1\u6709\u8be5\u5b57\u6bb5:{}", (Object)ConvertUtils.camelToUnderline(column));
            return ConvertUtils.camelToUnderline(column);
        }
        TableField annotation = field.getAnnotation(TableField.class);
        if (null != annotation && StrUtil.isNotBlank((CharSequence)(value = annotation.value()))) {
            return value;
        }
        return ConvertUtils.camelToUnderline(column);
    }

    private static String initialToCapital(String s) {
        String[] split;
        StringBuilder sb = new StringBuilder();
        if (s == null || s.trim().isEmpty()) {
            return sb.toString();
        }
        if (s.length() <= 1) {
            return sb.append(s).toString().toUpperCase();
        }
        for (String string : split = s.split("_")) {
            sb.append(StrUtil.upperFirst((CharSequence)string));
        }
        return StrUtil.lowerFirst((CharSequence)sb.toString());
    }

    private static Field getClassField(Class objClass, String column) {
        List field = QueryGenerator.getClassAllField(objClass);
        Optional<Field> any = field.stream().filter(f -> f.getName().equals(column)).findAny();
        return any.orElse(null);
    }

    private static void doSuperQuery(QueryWrapper<?> queryWrapper, Map<String, String[]> parameterMap, Map<String, String> fieldColumnMap) {
        if (parameterMap != null && parameterMap.containsKey(SUPER_QUERY_PARAMS)) {
            String superQueryParams = parameterMap.get(SUPER_QUERY_PARAMS)[0];
            String superQueryMatchType = parameterMap.get(SUPER_QUERY_MATCH_TYPE) != null ? parameterMap.get(SUPER_QUERY_MATCH_TYPE)[0] : MatchTypeEnum.AND.getValue();
            try {
                superQueryParams = URLDecoder.decode(superQueryParams, "UTF-8");
                List conditions = JSON.parseArray((String)superQueryParams, QueryCondition.class);
                log.info("---\u9ad8\u7ea7\u67e5\u8be2\u53c2\u6570-->" + conditions.toString());
                queryWrapper.and(wrapper -> {
                    for (QueryCondition rule : conditions) {
                        if (!ConvertUtils.isNotEmpty(rule.getFieldCode()) || !ConvertUtils.isNotEmpty(rule.getLogicSymbol()) || !ConvertUtils.isNotEmpty(rule.getFieldValue())) continue;
                        Object queryValue = rule.getFieldValue();
                        if ("date".equals(rule.getFieldType())) {
                            queryValue = DateUtils.str2Date(rule.getFieldValue(), DateUtils.date_sdf.get());
                        } else if ("datetime".equals(rule.getFieldType())) {
                            queryValue = DateUtils.str2Date(rule.getFieldValue(), DateUtils.datetimeFormat.get());
                        }
                        QueryGenerator.addEasyQuery(wrapper, StrUtil.blankToDefault((CharSequence)((CharSequence)fieldColumnMap.get(rule.getFieldCode())), (String)rule.getFieldCode()), QueryRuleEnum.getByValue(rule.getLogicSymbol()), queryValue);
                        if (!MatchTypeEnum.OR.getValue().equals(superQueryMatchType)) continue;
                        wrapper.or();
                    }
                });
            }
            catch (UnsupportedEncodingException e) {
                log.error("--\u9ad8\u7ea7\u67e5\u8be2\u53c2\u6570\u8f6c\u7801\u5931\u8d25!", (Throwable)e);
            }
            catch (Exception e) {
                log.error("--\u9ad8\u7ea7\u67e5\u8be2\u62fc\u63a5\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    private static QueryRuleEnum convert2Rule(Object value) {
        if (value == null) {
            return null;
        }
        String val = (value + "").trim();
        if (val.length() == 0) {
            return null;
        }
        QueryRuleEnum rule = null;
        if (val.length() >= 3 && QUERY_SEPARATE_KEYWORD.equals(val.substring(2, 3))) {
            rule = QueryRuleEnum.getByValue(val.substring(0, 2));
        }
        if (rule == null && val.length() >= 2 && QUERY_SEPARATE_KEYWORD.equals(val.substring(1, 2))) {
            rule = QueryRuleEnum.getByValue(val.substring(0, 1));
        }
        if (rule == null && val.contains(STAR)) {
            if (val.startsWith(STAR) && val.endsWith(STAR)) {
                rule = QueryRuleEnum.LIKE;
            } else if (val.startsWith(STAR)) {
                rule = QueryRuleEnum.LEFT_LIKE;
            } else if (val.endsWith(STAR)) {
                rule = QueryRuleEnum.RIGHT_LIKE;
            }
        }
        if (rule == null && val.contains(COMMA)) {
            rule = QueryRuleEnum.IN;
        }
        if (rule == null && val.startsWith(NOT_EQUAL)) {
            rule = QueryRuleEnum.NE;
        }
        return rule != null ? rule : QueryRuleEnum.EQ;
    }

    private static Object replaceValue(QueryRuleEnum rule, Object value) {
        if (rule == null) {
            return null;
        }
        if (!(value instanceof String)) {
            return value;
        }
        String val = (value + "").trim();
        if (rule == QueryRuleEnum.LIKE) {
            value = val.substring(1, val.length() - 1);
        } else if (rule == QueryRuleEnum.LEFT_LIKE || rule == QueryRuleEnum.NE) {
            value = val.substring(1);
        } else if (rule == QueryRuleEnum.RIGHT_LIKE) {
            value = val.substring(0, val.length() - 1);
        } else if (rule == QueryRuleEnum.IN) {
            value = val.split(COMMA);
        } else if (val.startsWith(rule.getValue())) {
            value = val.replaceFirst(rule.getValue(), "");
        } else if (val.startsWith(rule.getCondition() + QUERY_SEPARATE_KEYWORD)) {
            value = val.replaceFirst(rule.getCondition() + QUERY_SEPARATE_KEYWORD, "").trim();
        }
        return value;
    }

    private static void addQueryByRule(QueryWrapper<?> queryWrapper, String name, String type, String value, QueryRuleEnum rule) throws ParseException {
        if (!"".equals(value)) {
            Object temp;
            switch (type) {
                case "class java.lang.Integer": {
                    temp = Integer.parseInt(value);
                    break;
                }
                case "class java.math.BigDecimal": {
                    temp = new BigDecimal(value);
                    break;
                }
                case "class java.lang.Short": {
                    temp = Short.parseShort(value);
                    break;
                }
                case "class java.lang.Long": {
                    temp = Long.parseLong(value);
                    break;
                }
                case "class java.lang.Float": {
                    temp = Float.valueOf(Float.parseFloat(value));
                    break;
                }
                case "class java.lang.Double": {
                    temp = Double.parseDouble(value);
                    break;
                }
                case "class java.util.Date": {
                    temp = QueryGenerator.getDateQueryByRule(value, rule);
                    break;
                }
                default: {
                    temp = value;
                }
            }
            QueryGenerator.addEasyQuery(queryWrapper, name, rule, temp);
        }
    }

    private static Date getDateQueryByRule(String value, QueryRuleEnum rule) throws ParseException {
        Date date = null;
        if (value.length() == 10) {
            if (rule == QueryRuleEnum.GE) {
                date = QueryGenerator.getTime().parse(value + " 00:00:00");
            } else if (rule == QueryRuleEnum.LE) {
                date = QueryGenerator.getTime().parse(value + " 23:59:59");
            }
        }
        if (date == null) {
            date = QueryGenerator.getTime().parse(value);
        }
        return date;
    }

    private static void addEasyQuery(QueryWrapper<?> queryWrapper, String name, QueryRuleEnum rule, Object value) {
        if (value == null || rule == null) {
            return;
        }
        name = ConvertUtils.camelToUnderline(name);
        log.info("--\u67e5\u8be2\u89c4\u5219-->" + name + QUERY_SEPARATE_KEYWORD + rule.getValue() + QUERY_SEPARATE_KEYWORD + value);
        switch (rule) {
            case GT: {
                queryWrapper.gt((Object)name, value);
                break;
            }
            case GE: {
                queryWrapper.ge((Object)name, value);
                break;
            }
            case LT: {
                queryWrapper.lt((Object)name, value);
                break;
            }
            case LE: {
                queryWrapper.le((Object)name, value);
                break;
            }
            case EQ: {
                queryWrapper.eq((Object)name, value);
                break;
            }
            case NE: {
                queryWrapper.ne((Object)name, value);
                break;
            }
            case IN: {
                if (value instanceof String) {
                    queryWrapper.in((Object)name, (Object[])value.toString().split(COMMA));
                    break;
                }
                if (value instanceof String[]) {
                    queryWrapper.in((Object)name, (Object[])value);
                    break;
                }
                queryWrapper.in((Object)name, new Object[]{value});
                break;
            }
            case LIKE: {
                queryWrapper.like((Object)name, value);
                break;
            }
            case LEFT_LIKE: {
                queryWrapper.likeLeft((Object)name, value);
                break;
            }
            case RIGHT_LIKE: {
                queryWrapper.likeRight((Object)name, value);
                break;
            }
            default: {
                log.info("--\u67e5\u8be2\u89c4\u5219\u672a\u5339\u914d\u5230---");
            }
        }
    }

    private static boolean judgedIsUselessField(String name) {
        return "class".equals(name) || "ids".equals(name) || "page".equals(name) || "rows".equals(name) || "sort".equals(name) || ORDER_TYPE.equals(name) || KEY_WORD_COLUMN.equals(name) || "injectionEls".equals(name);
    }
}

