/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.justauth.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.justauth.entity.JustAuthConfig;
import com.els.modules.justauth.mapper.JustAuthConfigMapper;
import com.els.modules.justauth.service.JustAuthConfigService;
import com.els.modules.justauth.vo.JustAuthConfigVO;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class JustAuthConfigServiceImpl
extends BaseServiceImpl<JustAuthConfigMapper, JustAuthConfig>
implements JustAuthConfigService {
    @Override
    public IPage<JustAuthConfig> findPageList(Page<JustAuthConfig> page, QueryWrapper<JustAuthConfig> wrapper) {
        return ((JustAuthConfigMapper)this.baseMapper).findPageList(page, TenantContext.getTenant(), wrapper);
    }

    @Override
    public void companyEdit(JustAuthConfig config) {
        config.setEnterpriseName(SysUtil.getLoginUser().getEnterpriseName());
        if (StrUtil.isBlank((CharSequence)config.getCompanyConfigId())) {
            config.setId(null);
            config.setCreateBy(this.getLoginSubAndName());
            config.setCreateTime(new Date());
            config.setUpdateBy(this.getLoginSubAndName());
            config.setUpdateTime(new Date());
            this.save(config);
        } else {
            config.setId(config.getCompanyConfigId());
            this.updateById(config);
        }
    }

    @Override
    public JustAuthConfig getOneConfig(String elsAccount, String authType) {
        LambdaQueryWrapper eq = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)eq.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(JustAuthConfig::getAuthType, (Object)authType)).last(" limit 1");
        eq.orderByDesc(BaseEntity::getUpdateTime);
        return (JustAuthConfig)this.getOne((Wrapper)eq);
    }

    @Override
    public void saveJustAuth(JustAuthConfig config) {
        if (this.getOneConfig(TenantContext.getTenant(), config.getAuthType()) != null) {
            throw new ELSBootException("\u8be5\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728\uff01");
        }
        config.setEnterpriseName(SysUtil.getLoginUser().getEnterpriseName());
        this.save(config);
    }

    @Override
    public void updateJustAuth(JustAuthConfig config) {
        config.setAuthType(null);
        this.updateById(config);
    }

    @Override
    public List<JustAuthConfigVO> findBindList(String elsAccount, String userId) {
        return ((JustAuthConfigMapper)this.baseMapper).findBindList(elsAccount, userId);
    }
}

