/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.util.ThirdTokenUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.util.TemplateParseUtil;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.service.ThirdAccountService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(WxSendMsgImpl.class);
    private static final String WECHAT_MP_SEND_MSG_URL = "https://api.weixin.qq.com/cgi-bin/message/template/send";
    private static final String WECHAT_MP_OAUTH2_URL = "/els/account/thirdLogin/render/%s/mobile/wechat_mp";

    @Override
    public void doSendMsg(MsgVO msg) {
        ElsMsgConfigItem item = msg.getElsMsgConfigItem();
        ElsSubAccount account = msg.getReceiveAccount();
        ThirdAccountService thirdAccountService = SpringContextUtils.getBean(ThirdAccountService.class);
        List<ThirdAccount> list = thirdAccountService.getThirdAccount(msg.getBusAccount(), account.getId(), "WECHAT_MP");
        String urlAccount = msg.getBusAccount();
        if (list.isEmpty()) {
            urlAccount = urlAccount.equals(msg.getMsgConfigAccount()) ? "100000" : msg.getMsgConfigAccount();
            log.warn("WxSendMsgImpl {} receive not bind WECHAT_MP", (Object)msg.getBusAccount());
            list = thirdAccountService.getThirdAccount(urlAccount, account.getId(), "WECHAT_MP");
        }
        if (list.isEmpty()) {
            log.warn("WxSendMsgImpl {} receive not bind WECHAT_MP", (Object)urlAccount);
            return;
        }
        if (StrUtil.isBlank((CharSequence)item.getTemplateNumber())) {
            return;
        }
        String urlString = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + ThirdTokenUtil.getWechatMpToken(urlAccount);
        JSONObject body = new JSONObject();
        body.put("template_id", (Object)item.getTemplateNumber());
        body.put("url", (Object)this.getUrl(item.getLinkUrl() + "?" + msg.getUrlParam(), urlAccount));
        if (StrUtil.isNotBlank((CharSequence)item.getMsgContent()) && msg.getParams() != null) {
            JSONObject object = SysUtil.objectToJSON(msg.getParams());
            String msgContent = TemplateParseUtil.getTemplateText("", item.getMsgContent(), (Map<String, Object>)object);
            body.put("data", JSONObject.parse((String)msgContent));
        }
        for (ThirdAccount thirdAccount : list) {
            body.put("touser", (Object)thirdAccount.getThirdUserUuid());
            log.info("Wechat_mp Body:{}", (Object)body);
            String result = HttpUtil.post((String)urlString, (String)body.toString());
            log.info("Wechat_mp Send Result:{}", (Object)result);
        }
    }

    private String getUrl(String urlParam, String busAccount) {
        String routeUri = URLUtil.encodeAll((String)urlParam);
        StringBuilder url = new StringBuilder(StaticConfig.staticMap.get("serviceAddress"));
        url.append(String.format(WECHAT_MP_OAUTH2_URL, busAccount)).append("?routeUri=").append(routeUri);
        System.out.println(url.toString());
        return url.toString();
    }

    public static void main(String[] args) {
        String token = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=46_cdvi4kKxG51o5_ao4LYEVUKSrVEJ2tKBwrgKE688wb6NOaXJuSyH4AJzZmdAHZ_CepbFFpP6AjmiPXQBDMuh50-zESXmm5E28EcH5q5_YJJwXXFyuUuCs-7sjmW5Ydt9BBB_1U2Ztcd4CCgkIOTfABACIN";
        String body = "{\r\n           \"touser\":\"oCQZC6GSLuribL-Ez_WK_Qz4o4XU\",\r\n           \"template_id\":\"TrCHKlWNdYk8_4v-T1ovVbi1t4IOC9guBrj84diJpyo\",\r\n           \"url\":\"http://v5sit.51qqt.com/user/login\",           \r\n           \"data\":{\r\n           \t\"number\": {\r\n                       \"value\":\"aaa\",\r\n                       \"color\":\"#173177\"\r\n                   }\r\n           }\r\n}";
        HttpUtil.post((String)token, (String)body);
    }
}

