/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.entity.I18n;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.service.I18nService;
import com.els.modules.system.util.I18nUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dictItem"})
public class DictItemController {
    private static final Logger log = LoggerFactory.getLogger(DictItemController.class);
    @Autowired
    private DictItemService dictItemService;
    @Autowired
    private I18nService i18nService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String CATALOGUE = "sys:dict:";

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<DictItem>> queryPageList(DictItem sysDictItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<IPage<DictItem>> result = new Result<IPage<DictItem>>();
        QueryWrapper<DictItem> queryWrapper = QueryGenerator.initQueryWrapper(sysDictItem, req.getParameterMap());
        queryWrapper.orderByAsc((Object)"sort_order");
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.dictItemService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @RequestMapping(value={"/sysList"}, method={RequestMethod.GET})
    public Result<IPage<DictItem>> querySysPageList(DictItem sysDictItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<IPage<DictItem>> result = new Result<IPage<DictItem>>();
        QueryWrapper<DictItem> queryWrapper = QueryGenerator.initQueryWrapper(sysDictItem, req.getParameterMap());
        queryWrapper.orderByAsc((Object)"sort_order");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.dictItemService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<DictItem> add(@RequestBody DictItem sysDictItem) {
        List<DictItem> dictItemList = this.dictItemService.selectItemsByMainId(sysDictItem.getDictId());
        for (DictItem dictItem : dictItemList) {
            if (dictItem.getItemText().equals(sysDictItem.getItemText())) {
                throw new ELSBootException(I18nUtil.translate("i18n_alert_VaKmWrRLIMKW_1a6e8a1d", "\u65b0\u589e\u5931\u8d25\uff0c\u8be5\u540d\u79f0\u5df2\u5b58\u5728\uff01"));
            }
            if (!dictItem.getItemValue().equals(sysDictItem.getItemValue())) continue;
            throw new ELSBootException(I18nUtil.translate("i18n_alert_VaKmWrWFRIMKW_c9dc2a42", "\u65b0\u589e\u5931\u8d25\uff0c\u8be5\u6570\u636e\u503c\u5df2\u5b58\u5728\uff01"));
        }
        Result<DictItem> result = new Result<DictItem>();
        try {
            sysDictItem.setCreateTime(new Date());
            this.dictItemService.save(sysDictItem);
            this.cleanRedis(sysDictItem.getDictId(), TenantContext.getTenant());
            result.success(I18nUtil.translate("i18n_alert_savaSuccess", "\u4fdd\u5b58\u6210\u529f\uff01"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500(I18nUtil.translate("i18n_alert_tkKm_2f078e83", "\u64cd\u4f5c\u5931\u8d25"));
        }
        return result;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<DictItem> edit(@RequestBody DictItem sysDictItem) {
        List<DictItem> dictItemList = this.dictItemService.selectItemsByMainId(sysDictItem.getDictId());
        for (DictItem dictItem : dictItemList) {
            if (dictItem.getItemText().equals(sysDictItem.getItemText()) && !dictItem.getId().equals(sysDictItem.getId())) {
                throw new ELSBootException(I18nUtil.translate("i18n_alert_crKmWrRLIMKW_9217b3fa", "\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u540d\u79f0\u5df2\u5b58\u5728\uff01"));
            }
            if (!dictItem.getItemValue().equals(sysDictItem.getItemValue()) || dictItem.getId().equals(sysDictItem.getId())) continue;
            throw new ELSBootException(I18nUtil.translate("i18n_alert_crKmWrWFRIMKW_47583c05", "\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u6570\u636e\u503c\u5df2\u5b58\u5728\uff01"));
        }
        Result<DictItem> result = new Result<DictItem>();
        DictItem sysdict = (DictItem)this.dictItemService.getById((Serializable)((Object)sysDictItem.getId()));
        if (sysdict == null) {
            result.error500(I18nUtil.translate("i18n_alert_LYuIdKD_12f57c8c", "\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53"));
        } else {
            String inputkey = sysDictItem.getItemTextI18nKey();
            List zh = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.i18nService.lambdaQuery().eq(I18n::getLanguage, (Object)"zh")).in(I18n::getI18nValue, new Object[]{inputkey})).list();
            Map<String, String> keyMap = zh.stream().collect(Collectors.toMap(I18n::getI18nValue, I18n::getI18nKey));
            HashMap<String, String> nokeyMap = new HashMap<String, String>();
            if (StringUtils.isNotBlank((String)sysDictItem.getItemText()) && StringUtils.isBlank((String)sysDictItem.getItemTextI18nKey())) {
                String s = this.i18nService.checkAndAdd(sysDictItem.getItemText());
                sysDictItem.setItemTextI18nKey(s);
            }
            this.i18nService.addOtherKey(nokeyMap);
            sysDictItem.setUpdateTime(new Date());
            boolean ok = this.dictItemService.updateById(sysDictItem);
            if (ok) {
                result.success("\u7f16\u8f91\u6210\u529f!");
            }
            this.cleanRedis(sysDictItem.getDictId(), TenantContext.getTenant());
        }
        return result;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<DictItem> delete(@RequestParam(name="id", required=true) String id) {
        Result<DictItem> result = new Result<DictItem>();
        DictItem joinSystem = (DictItem)this.dictItemService.getById((Serializable)((Object)id));
        String dict_id = null;
        if (joinSystem == null) {
            result.error500(I18nUtil.translate("i18n_alert_LYuIdKD_12f57c8c", "\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53"));
        } else {
            dict_id = joinSystem.getDictId();
            boolean ok = this.dictItemService.removeById((Serializable)((Object)id));
            if (ok) {
                result.success(I18nUtil.translate("i18n_alert_deleteSuccess", "\u5220\u9664\u6210\u529f!"));
            }
            this.cleanRedis(dict_id, TenantContext.getTenant());
        }
        return result;
    }

    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.GET})
    @CacheEvict(value={"sys:cache:dict"}, allEntries=true)
    public Result<DictItem> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result<DictItem> result = new Result<DictItem>();
        if (ids == null || "".equals(ids.trim())) {
            result.error500(I18nUtil.translate("i18n_alert_sWxKqW_a84a623d", "\u53c2\u6570\u4e0d\u8bc6\u522b\uff01"));
        } else {
            DictItem joinSystem = (DictItem)this.dictItemService.getById((Serializable)((Object)ids.split(",")[0]));
            this.dictItemService.removeByIds(Arrays.asList(ids.split(",")));
            if (joinSystem != null) {
                this.cleanRedis(joinSystem.getDictId(), TenantContext.getTenant());
            }
            result.success(I18nUtil.translate("i18n_alert_deleteSuccess", "\u5220\u9664\u6210\u529f!"));
        }
        return result;
    }

    public void cleanRedis(String dict_id, String elsAccount) {
        Dict dict = this.dictItemService.selectByDictId(dict_id, elsAccount);
        this.redisUtil.set(CATALOGUE + elsAccount + ":" + dict.getDictCode(), null);
    }
}

