/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.system.service.PermissionService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(consumerGroup="${rocketmq.reBuildSaleMenu.group}", topic="${rocketmq.reBuildSaleMenu.destination}")
public class RebuildSaleMenuListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(RebuildSaleMenuListener.class);
    @Resource
    private PermissionService permissionServiceImpl;
    @Value(value="${rocketmq.reBuildSaleMenu.destination}")
    private String reBuildSaleMenu;
    @Autowired
    private RocketMQTemplate rocketMqTemplate;

    public void onMessage(String msgBody) {
        JSONObject body = null;
        try {
            if (StringUtils.isBlank((CharSequence)msgBody)) {
                return;
            }
            body = JSONObject.parseObject((String)msgBody);
            log.info(":::\u63a5\u53d7\u5230\u6765\u81ea\u91c7\u8d2d\u8ba2\u5355\u53d8\u66f4\u6743\u9650\uff0c\u66f4\u6539\u9500\u552e\u6743\u9650\u7684\u6570\u636e\u4fe1\u606f:{}", (Object)body);
            this.permissionServiceImpl.rebuildSaleMenuByMsg(body);
        }
        catch (Exception e) {
            log.error("inputRebuildSaleMenu_receive_msgBody:{},error:{}", (Object)msgBody, (Object)e.getMessage());
            log.error("::\u6388\u6743\u7b49\u5f85\u8ba2\u5355\u6570\u636e\u6d88\u8d39\u5f02\u5e38:{}", (Object)e.getMessage());
            if (null == body) {
                return;
            }
            int level = body.getInteger("level");
            if (level > 3) {
                return;
            }
            body.put("level", (Object)(level + 1));
            this.rocketMqTemplate.syncSend(this.reBuildSaleMenu, MessageBuilder.withPayload((Object)JSON.toJSONString((Object)body)).build(), 5000L, level * 3);
        }
    }
}

