/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.config.mybatis.TenantContext;
import com.els.modules.integration.service.SrmToIPaasService;
import com.els.modules.system.entity.ElsCompanySet;
import com.els.modules.system.mapper.ElsCompanySetMapper;
import com.els.modules.system.service.ElsCompanySetService;
import com.els.modules.system.vo.ElsCompanySetVO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ElsCompanySetServiceImpl
extends ServiceImpl<ElsCompanySetMapper, ElsCompanySet>
implements ElsCompanySetService {
    private static final String AUTHORIZATION_TO_PLATFORM = "authorizationToPlatform";
    @Autowired
    private SrmToIPaasService iPaasService;

    @Override
    public List<ElsCompanySetVO> findList(String elsAccount) {
        return ((ElsCompanySetMapper)this.baseMapper).findList(elsAccount);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public String save(List<ElsCompanySetVO> list) {
        String message = null;
        String elsAccount = TenantContext.getTenant();
        ((ElsCompanySetMapper)this.baseMapper).deleteByAccount(elsAccount);
        ArrayList<ElsCompanySet> companySetList = new ArrayList<ElsCompanySet>();
        for (ElsCompanySetVO vo : list) {
            ElsCompanySet companySet = new ElsCompanySet();
            BeanUtils.copyProperties((Object)vo, (Object)companySet);
            companySet.setId(null);
            companySet.setSystemId(vo.getId());
            companySet.setElsAccount(elsAccount);
            companySetList.add(companySet);
            message = this.authorizationToPlatform(vo.getItemCode(), vo.getDefaultValue());
        }
        if (!companySetList.isEmpty()) {
            this.saveBatch(companySetList);
        }
        return message;
    }

    private String authorizationToPlatform(String itemCode, String value) {
        if (!AUTHORIZATION_TO_PLATFORM.equals(itemCode)) {
            return null;
        }
        JSONObject data = new JSONObject();
        data.put("account", (Object)TenantContext.getTenant());
        data.put("auth", (Object)value);
        JSONObject result = this.iPaasService.callIPaasInterface(data, "enterpriseAuthUpdate");
        return result.containsKey((Object)"success") && result.getBoolean("success") == false && result.containsKey((Object)"message") ? "iPaaS\u5e73\u53f0\u3010\u4f01\u4e1a\u6388\u6743\u66f4\u65b0\u3011\u8c03\u7528\u51fa\u9519\uff1a" + result.getString("message") : null;
    }
}

