/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsPasswordPolicy;
import com.els.modules.system.entity.ElsPasswordSecurity;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ElsSubAccountLoginLockRecord;
import com.els.modules.system.enums.i18n.I18nElsPwSecurityEnum;
import com.els.modules.system.enums.i18n.I18nRecordOperaEnum;
import com.els.modules.system.mapper.ElsPasswordPolicyMapper;
import com.els.modules.system.mapper.ElsPasswordSecurityMapper;
import com.els.modules.system.mapper.ElsSubAccountLoginLockRecordMapper;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.service.ElsPasswordSecurityService;
import com.els.modules.system.util.AssertI18nUtil;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.util.PwVerifyUtil;
import com.els.modules.system.vo.ElsPasswordSecurityVo;
import com.els.modules.system.vo.ElsPwSecurityEditVo;
import com.els.modules.system.vo.ElsPwSecuritySaveVo;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ElsPasswordSecurityServiceImpl
extends BaseServiceImpl<ElsPasswordSecurityMapper, ElsPasswordSecurity>
implements ElsPasswordSecurityService {
    @Resource
    ElsPasswordPolicyMapper pwPolicyMapper;
    @Resource
    ElsSubAccountMapper elsSubAccountMapper;
    @Resource
    ElsPasswordSecurityMapper elsPasswordSecurityMapper;
    @Autowired
    ElsSubAccountLoginLockRecordMapper elsSubAccountLoginLockRecordMapper;
    @Autowired
    private RedisUtil redisUtil;
    private ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors() * 2, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(200), r -> new Thread(r, "User-LoginLock"));

    private String getLoginErrorNumKey(String elsAccount, String elsSubAccount) {
        return "CACHE_LOGIN_ERROR_LOCK_" + elsAccount + "_" + elsSubAccount;
    }

    private long getLoginErrorExpireTime() {
        return 300L;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveElsPasswordSecurity(ElsPwSecuritySaveVo elsPwSecuritySaveVo) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(BaseEntity::getElsAccount, (Object)elsPwSecuritySaveVo.getElsAccount());
        Assert.isTrue((((ElsPasswordSecurityMapper)this.baseMapper).selectCount((Wrapper)lambdaQueryWrapper) <= 0 ? 1 : 0) != 0, (String)I18nUtil.translate(I18nRecordOperaEnum.I18N_RECORD_ALREADY_EXISTS));
        ElsPasswordSecurity elsPasswordSecurity = new ElsPasswordSecurity();
        BeanUtils.copyProperties((Object)elsPwSecuritySaveVo, (Object)elsPasswordSecurity);
        Date now = new Date();
        elsPasswordSecurity.setCreateTime(now).setUpdateTime(now);
        ((ElsPasswordSecurityMapper)this.baseMapper).insert(elsPasswordSecurity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateElsPasswordSecurity(ElsPwSecurityEditVo elsPwSecurityEditVo) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(BaseEntity::getId, (Object)elsPwSecurityEditVo.getId())).eq(BaseEntity::getElsAccount, (Object)elsPwSecurityEditVo.getElsAccount());
        lambdaQueryWrapper.last(" limit 1");
        lambdaQueryWrapper.orderByDesc(BaseEntity::getUpdateTime);
        ElsPasswordSecurity one = (ElsPasswordSecurity)((ElsPasswordSecurityMapper)this.baseMapper).selectOne((Wrapper)lambdaQueryWrapper);
        AssertI18nUtil.isTrue(null == one, I18nRecordOperaEnum.I18N_RECORD_NOT_EXISTS);
        Integer old = one.getErrorLockTime();
        ElsPasswordSecurity elsPasswordSecurity = new ElsPasswordSecurity();
        elsPasswordSecurity.setComplexity(elsPwSecurityEditVo.getComplexity()).setMinLength(elsPwSecurityEditVo.getMinLength()).setModifyInterval(elsPwSecurityEditVo.getModifyInterval()).setErrorLockTime(elsPwSecurityEditVo.getErrorLockTime()).setErrorLock(elsPwSecurityEditVo.getErrorLock()).setAllowRepeatLogin(elsPwSecurityEditVo.getAllowRepeatLogin()).setUpdateBy(elsPwSecurityEditVo.getUpdateBy()).setUpdateTime(new Date()).setId(elsPwSecurityEditVo.getId());
        ((ElsPasswordSecurityMapper)this.baseMapper).updateById(elsPasswordSecurity);
        if (old != null && !old.equals(elsPasswordSecurity.getErrorLockTime())) {
            this.refreshLockTime(old, elsPasswordSecurity.getErrorLockTime());
        }
    }

    @Async
    public void refreshLockTime(Integer old, Integer errorLockTime) {
        long newTime = (long)((Integer)ObjectUtil.defaultIfNull((Object)errorLockTime, (Object)0)).intValue() * 60L;
        long oldTime = (long)old.intValue() * 60L;
        Set<String> keys = this.redisUtil.getKeys("CACHE_LOGIN_ERROR_LOCK_" + TenantContext.getTenant() + "_*");
        for (String k : keys) {
            long fastTime = newTime - (oldTime - this.redisUtil.getExpire(k));
            this.redisUtil.set(k, this.redisUtil.get(k), fastTime > 0L ? fastTime : 1L);
        }
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ElsPasswordSecurityVo getElsPasswordSecurity(String elsAccount) {
        return ((ElsPasswordSecurityMapper)this.baseMapper).getElsPasswordSecurity(elsAccount);
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public String verifyModifyInterval(String elsAccount, String elsSubAccount) {
        Integer modifyInterval = ((ElsPasswordSecurityMapper)this.baseMapper).getModifyInterval(elsAccount);
        if (modifyInterval == null) {
            return null;
        }
        Date lastModifyDate = this.pwPolicyMapper.getPwPolicyUpdateTime(elsAccount, elsSubAccount);
        if (lastModifyDate == null) {
            lastModifyDate = this.elsSubAccountMapper.getUserCreateDate(elsAccount, elsSubAccount);
        }
        if (lastModifyDate != null) {
            return PwVerifyUtil.pwModifyIntervalVerify(lastModifyDate, modifyInterval);
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public void verifyErrorLock(String elsAccount, String elsSubAccount) {
        Integer errorLock = ((ElsPasswordSecurityMapper)this.baseMapper).getErrorLock(elsAccount);
        if (errorLock == null || errorLock <= 0) {
            return;
        }
        String loginErrorNumKey = this.getLoginErrorNumKey(elsAccount, elsSubAccount);
        Object cacheErrorNum = this.redisUtil.get(loginErrorNumKey);
        boolean flag = cacheErrorNum != null && Integer.parseInt(cacheErrorNum.toString()) > errorLock;
        ElsPasswordSecurityVo elsPasswordSecurity = this.elsPasswordSecurityMapper.getElsPasswordSecurity(elsAccount);
        if (null != elsPasswordSecurity && elsPasswordSecurity.getErrorLockTime() != -1 && this.redisUtil.getExpire(loginErrorNumKey) == -1L && flag) {
            this.redisUtil.del(loginErrorNumKey);
        }
        if (cacheErrorNum == null || Integer.parseInt(cacheErrorNum.toString()) < errorLock) {
            return;
        }
        Integer errorLockTime = 0;
        Integer errorNum = Integer.parseInt(cacheErrorNum.toString());
        if (null != elsPasswordSecurity) {
            errorLockTime = elsPasswordSecurity.getErrorLockTime();
        }
        if (errorNum > errorLock) {
            if (errorLockTime <= -1) {
                AssertI18nUtil.isTrue(true, I18nElsPwSecurityEnum.I18N_LOGIN_ERROR_LOCK_FOREVER, String.valueOf(errorLock));
            } else {
                AssertI18nUtil.isTrue(true, I18nElsPwSecurityEnum.I18N_LOGIN_ERROR_LOCK, String.valueOf(errorLock), errorLockTime.toString());
            }
        }
        if (null == errorLockTime || errorLockTime == 0) {
            return;
        }
        Integer lockTime = errorLockTime;
        this.poolExecutor.execute(() -> this.saveLoginLockRecord(elsAccount, elsSubAccount, lockTime));
        if (errorNum.equals(errorLock)) {
            errorNum = errorNum + 1;
        }
        if (errorLockTime <= -1) {
            this.redisUtil.set(loginErrorNumKey, errorNum);
            AssertI18nUtil.isTrue(true, I18nElsPwSecurityEnum.I18N_LOGIN_ERROR_LOCK_FOREVER, String.valueOf(cacheErrorNum));
        } else {
            this.redisUtil.set(loginErrorNumKey, errorNum, (long)errorLockTime.intValue() * 60L);
            AssertI18nUtil.isTrue(true, I18nElsPwSecurityEnum.I18N_LOGIN_ERROR_LOCK, String.valueOf(cacheErrorNum), errorLockTime.toString());
        }
    }

    @Override
    public void setUpLoginErrorNum(String elsAccount, String elsSubAccount) {
        String loginErrorNumKey = this.getLoginErrorNumKey(elsAccount, elsSubAccount);
        Object cacheErrorNum = this.redisUtil.get(loginErrorNumKey);
        ElsPasswordSecurityVo elsPasswordSecurity = this.elsPasswordSecurityMapper.getElsPasswordSecurity(TenantContext.getTenant());
        if (null == elsPasswordSecurity) {
            this.redisUtil.del(loginErrorNumKey);
            return;
        }
        Integer errorLockTime = (Integer)ObjectUtil.defaultIfNull((Object)elsPasswordSecurity.getErrorLockTime(), (Object)0);
        long time = (long)errorLockTime.intValue() * 60L;
        if (time == 0L) {
            time = 1L;
        }
        if (cacheErrorNum == null) {
            if (errorLockTime <= -1) {
                this.redisUtil.set(loginErrorNumKey, 1);
            } else {
                this.redisUtil.set(loginErrorNumKey, 1, time);
            }
            return;
        }
        if (errorLockTime <= -1) {
            this.redisUtil.set(loginErrorNumKey, Integer.parseInt(cacheErrorNum.toString()) + 1);
            return;
        }
        Integer num = Integer.parseInt(cacheErrorNum.toString()) + 1;
        this.redisUtil.set(loginErrorNumKey, num, this.redisUtil.getExpire(loginErrorNumKey));
    }

    public void saveLoginLockRecord(String elsAccount, String elsSubAccount, Integer errorLockTime) {
        ElsSubAccount userByAccount = this.elsSubAccountMapper.getUserByAccount(elsAccount + "_" + elsSubAccount);
        if (null == userByAccount) {
            return;
        }
        DateTime lockDate = DateUtil.date();
        ElsSubAccountLoginLockRecord record = new ElsSubAccountLoginLockRecord();
        record.setElsSubAccount(elsSubAccount);
        record.setElsAccount(elsAccount);
        record.setUserName(userByAccount.getRealname());
        record.setLockDate((Date)lockDate);
        record.setLockTime(errorLockTime);
        this.elsSubAccountLoginLockRecordMapper.insert(record);
        ElsPasswordPolicy elsPasswordPolicy = this.getElsPasswordPolicy(elsAccount, elsSubAccount);
        if (null == elsPasswordPolicy) {
            elsPasswordPolicy = new ElsPasswordPolicy();
            elsPasswordPolicy.setElsAccount(elsAccount);
            elsPasswordPolicy.setElsSubAccount(elsSubAccount);
        }
        elsPasswordPolicy.setLastErrorLockTime((Date)lockDate);
        if (null == elsPasswordPolicy.getId()) {
            this.pwPolicyMapper.insert(elsPasswordPolicy);
            return;
        }
        this.pwPolicyMapper.updateById(elsPasswordPolicy);
    }

    private ElsPasswordPolicy getElsPasswordPolicy(String elsAccount, String elsSubAccount) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(ElsPasswordPolicy::getElsSubAccount, (Object)elsSubAccount)).last(" limit 1");
        wrapper.orderByDesc(BaseEntity::getUpdateTime);
        return (ElsPasswordPolicy)this.pwPolicyMapper.selectOne((Wrapper)wrapper);
    }
}

