/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SqlInjectionUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.modules.system.service.AbstractExcelHandler;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.impl.DictServiceImpl;
import com.els.modules.system.util.I18nUtil;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ExcelDataListener
extends AnalysisEventListener<Map<Integer, String>> {
    private List<Map<String, Object>> importDataList = new ArrayList<Map<String, Object>>(16);
    private Map<String, Object> primaryMap = new HashMap<String, Object>(16);
    private List<ExcelDetail> excelDetailList;
    private AbstractExcelHandler handler;
    private DictService dictService;
    private String dataKey;
    private List<Map<String, Object>> otherSheetList;
    private List<String> fileHeadTitle;
    private int row = 0;

    public ExcelDataListener(AbstractExcelHandler handler, List<ExcelDetail> excelDetailList, String dataKey, List<Map<String, Object>> otherSheetList) {
        this.handler = handler;
        this.excelDetailList = excelDetailList;
        this.dataKey = dataKey;
        this.dictService = SpringContextUtils.getBean(DictServiceImpl.class);
        this.otherSheetList = otherSheetList;
    }

    public List<Map<String, Object>> getImportDataList() {
        return this.importDataList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDictValue(ExcelDetail detail, String val) {
        String dictCode = detail.getDataFormat();
        if (!dictCode.contains("#")) {
            if (!dictCode.contains(",")) return this.dictService.queryDictValueByText(dictCode, val);
        }
        String[] params = null;
        params = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
        if (params.length < 3) {
            throw new ELSBootException(I18nUtil.translate("", "\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e"));
        }
        String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
        SqlInjectionUtil.filterContent(sqlInjCheck);
        if (params.length != 4) throw new ELSBootException(I18nUtil.translate("", "\u5b57\u5178\u4e0d\u5339\u914d"));
        String filterSql = params[3] + " and " + params[1] + " = '" + val + "'";
        SqlInjectionUtil.filterContent(filterSql);
        return this.dictService.queryTableDictItemsByValue(params[0], params[1], params[2], filterSql, val);
    }

    public void invoke(Map<Integer, String> data, AnalysisContext context) {
        ++this.row;
        if (this.row == 1) {
            this.fileHeadTitle = Lists.newArrayList(data.values());
            return;
        }
        int headRow = 2;
        if (this.row <= headRow) {
            return;
        }
        HashMap newData = new HashMap(data.size());
        if (CollUtil.isNotEmpty(data)) {
            data.forEach((key, val) -> {
                String title;
                try {
                    title = this.fileHeadTitle.get((int)key);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ELSBootException(I18nUtil.translate("i18n_alert_CcmKNS_58e2005d", "\u5185\u5bb9\u683c\u5f0f\u9519\u8bef"));
                }
                newData.put(title, val);
            });
        }
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        StringBuilder primaryKey = new StringBuilder();
        for (ExcelDetail detail : this.excelDetailList) {
            String columnCode = detail.getColumnCode();
            String val2 = (String)newData.get(columnCode);
            if (StrUtil.isNotBlank((CharSequence)val2)) {
                if (ExcelDataTypeEnum.DICT.getCode().equals(detail.getDataType())) {
                    StringBuffer temVal = new StringBuffer("");
                    if (StrUtil.isNotBlank((CharSequence)val2) && val2.contains(",")) {
                        String[] split = val2.split(",");
                        for (int i = 0; i < split.length; ++i) {
                            String dictValue;
                            if (!StrUtil.isNotBlank((CharSequence)split[i]) || !StrUtil.isNotBlank((CharSequence)(dictValue = this.getDictValue(detail, split[i])))) continue;
                            temVal.append(dictValue).append(",");
                        }
                    } else {
                        temVal.append(this.getDictValue(detail, val2));
                    }
                    val2 = temVal.toString();
                    if (val2.endsWith(",")) {
                        val2 = val2.substring(0, val2.length() - 1);
                    }
                    if (StrUtil.isBlank((CharSequence)val2)) {
                        throw new ELSBootException(I18nUtil.translate("", detail.getColumnName() + "[" + val2 + "]\u4e0d\u5b58\u5728\u4e8e\u6570\u636e\u5b57\u5178\u7f16\u7801[" + detail.getDataFormat() + "]\u8303\u56f4\u5185"));
                    }
                }
                if (ExcelDataTypeEnum.NUMBER.getCode().equals(detail.getDataType())) {
                    try {
                        Double dVal = Double.valueOf(val2);
                        BigDecimal bVal = BigDecimal.valueOf(dVal).setScale(4, 4);
                        dataMap.put(columnCode, bVal.stripTrailingZeros().toPlainString());
                    }
                    catch (NumberFormatException e) {
                        dataMap.put(detail.getColumnCode(), val2);
                    }
                } else {
                    dataMap.put(columnCode, val2);
                }
                if (ExcelDataTypeEnum.DATE.getCode().equals(detail.getDataType()) && !StringUtils.isEmpty((CharSequence)val2)) {
                    try {
                        DateTime date = DateUtil.parse((CharSequence)val2);
                        String dateStr = DateUtil.format((Date)date, (String)"yyyy-MM-dd");
                        dataMap.put(columnCode, dateStr);
                    }
                    catch (Exception e) {
                        dataMap.put(detail.getColumnCode(), val2);
                    }
                } else {
                    dataMap.put(columnCode, val2);
                }
                if (!CommonConstant.STATUS_YES.equals(detail.getPrimaryKey())) continue;
                primaryKey.append(val2).append(",");
                continue;
            }
            if (!CommonConstant.STATUS_YES.equals(detail.getRequired())) continue;
            throw new ELSBootException(I18nUtil.translate("", detail.getColumnName() + "\u662f\u5fc5\u586b\u5b57\u6bb5\uff0c\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtil.isNotBlank((CharSequence)primaryKey.toString())) {
            if (this.primaryMap.containsKey(primaryKey.toString())) {
                throw new ELSBootException(I18nUtil.translate("", primaryKey + "\u552f\u4e00\u952e\u91cd\u590d"));
            }
            this.primaryMap.put(primaryKey.toString(), CommonConstant.STATUS_YES);
        }
        if (dataMap.size() == 0) {
            return;
        }
        dataMap.put("els_account", TenantContext.getTenant());
        this.importDataList.add(dataMap);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.fileHeadTitle = null;
        this.row = 0;
        if (StringUtils.isBlank((CharSequence)this.dataKey)) {
            if (CollectionUtil.isNotEmpty(this.otherSheetList)) {
                HashMap<String, List<Map<String, Object>>> otherMap = new HashMap<String, List<Map<String, Object>>>();
                otherMap.put("otherSheetList", this.otherSheetList);
                this.importDataList.add(otherMap);
            }
            this.handler.importExcel(this.importDataList);
        } else {
            RedisUtil redisUtil = SpringContextUtils.getBean(RedisUtil.class);
            redisUtil.set(this.dataKey, this.importDataList);
        }
    }
}

