/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.system.entity.CodeGenerator;
import com.els.modules.system.entity.CodeGeneratorDetail;
import com.els.modules.system.entity.CodeGeneratorSerial;
import com.els.modules.system.service.CodeGeneratorDetailService;
import com.els.modules.system.service.CodeGeneratorSerialService;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.vo.CodeGeneratorVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/system/codeGenerator"})
@Api(tags={"\u7f16\u7801\u89c4\u5219"})
public class CodeGeneratorController
extends BaseController<CodeGenerator, CodeGeneratorService> {
    private static final Logger log = LoggerFactory.getLogger(CodeGeneratorController.class);
    @Autowired
    private CodeGeneratorService codeGeneratorService;
    @Autowired
    private CodeGeneratorDetailService codeGeneratorDetailService;
    @Autowired
    private CodeGeneratorSerialService codeGeneratorSerialService;

    @ApiOperation(value="\u7f16\u7801\u89c4\u5219-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u7f16\u7801\u89c4\u5219-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(CodeGenerator codeGenerator, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<CodeGenerator> queryWrapper = QueryGenerator.initQueryWrapper(codeGenerator, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.codeGeneratorService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u7f16\u7801\u89c4\u5219-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u7f16\u7801\u89c4\u5219-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/listSys"})
    public Result<?> querySysPageList(CodeGenerator codeGenerator, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<CodeGenerator> queryWrapper = QueryGenerator.initQueryWrapper(codeGenerator, req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.codeGeneratorService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @AutoLog(value="\u7f16\u7801\u89c4\u5219-\u6dfb\u52a0", operateType=2)
    @ApiOperation(value="\u7f16\u7801\u89c4\u5219-\u6dfb\u52a0", notes="\u7f16\u7801\u89c4\u5219-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody CodeGeneratorVO codeGeneratorPage) {
        Assert.notEmpty(codeGeneratorPage.getCodeGeneratorDetailList(), (String)I18nUtil.translate("i18n_alert_AoLFRHxOLV_4eaf3048", "\u7f16\u7801\u89c4\u5219\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a"));
        CodeGenerator codeGenerator = new CodeGenerator();
        BeanUtils.copyProperties((Object)codeGeneratorPage, (Object)codeGenerator);
        this.codeGeneratorService.saveMain(codeGenerator, codeGeneratorPage.getCodeGeneratorDetailList());
        return this.commonSuccessResult(2);
    }

    @AutoLog(value="\u7f16\u7801\u89c4\u5219-\u7f16\u8f91,id:+#codeGeneratorPage.id", operateType=3)
    @ApiOperation(value="\u7f16\u7801\u89c4\u5219-\u7f16\u8f91", notes="\u7f16\u7801\u89c4\u5219-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody CodeGeneratorVO codeGeneratorPage) {
        Assert.notEmpty(codeGeneratorPage.getCodeGeneratorDetailList(), (String)I18nUtil.translate("i18n_alert_AoLFRHxOLV_4eaf3048", "\u7f16\u7801\u89c4\u5219\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a"));
        CodeGenerator codeGenerator = new CodeGenerator();
        BeanUtils.copyProperties((Object)codeGeneratorPage, (Object)codeGenerator);
        this.codeGeneratorService.updateMain(codeGenerator, codeGeneratorPage.getCodeGeneratorDetailList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7id\u5220\u9664", operateType=4)
    @ApiOperation(value="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7id\u5220\u9664", notes="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.codeGeneratorService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7f16\u7801\u89c4\u5219-\u6279\u91cf\u5220\u9664", operateType=4)
    @ApiOperation(value="\u7f16\u7801\u89c4\u5219-\u6279\u91cf\u5220\u9664", notes="\u7f16\u7801\u89c4\u5219-\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.codeGeneratorService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7id\u67e5\u8be2", notes="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        CodeGenerator codeGenerator = (CodeGenerator)this.codeGeneratorService.getById((Serializable)((Object)id));
        CodeGeneratorVO generatorVO = new CodeGeneratorVO();
        BeanUtils.copyProperties((Object)codeGenerator, (Object)generatorVO);
        List<CodeGeneratorDetail> codeGeneratorDetailList = this.codeGeneratorDetailService.selectByMainId(id);
        List<CodeGeneratorSerial> codeGeneratorSerialList = this.codeGeneratorSerialService.selectByMainId(id);
        generatorVO.setCodeGeneratorDetailList(codeGeneratorDetailList);
        generatorVO.setCodeGeneratorSerialList(codeGeneratorSerialList);
        return Result.ok(generatorVO);
    }

    @ApiOperation(value="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7\u7f16\u7801\u89c4\u5219id\u67e5\u8be2\u7f16\u7801\u89c4\u5219\u660e\u7ec6", notes="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7\u7f16\u7801\u89c4\u5219id\u67e5\u8be2\u7f16\u7801\u89c4\u5219\u660e\u7ec6")
    @GetMapping(value={"/queryCodeGeneratorDetailByMainId"})
    public Result<?> queryCodeGeneratorDetailListByMainId(@RequestParam(name="id") String id) {
        List<CodeGeneratorDetail> codeGeneratorDetailList = this.codeGeneratorDetailService.selectByMainId(id);
        return Result.ok(codeGeneratorDetailList);
    }

    @ApiOperation(value="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7\u7f16\u7801\u89c4\u5219id\u67e5\u8be2\u7f16\u7801\u5e8f\u5217", notes="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7\u7f16\u7801\u89c4\u5219id\u67e5\u8be2\u7f16\u7801\u5e8f\u5217")
    @GetMapping(value={"/queryCodeGeneratorSerialByMainId"})
    public Result<?> queryCodeGeneratorSerialListByMainId(@RequestParam(name="id") String id) {
        List<CodeGeneratorSerial> codeGeneratorSerialList = this.codeGeneratorSerialService.selectByMainId(id);
        return Result.ok(codeGeneratorSerialList);
    }

    @AutoLog(value="\u7f16\u7801\u89c4\u5219-\u5bfc\u51faExcel", operateType=6)
    @RequestMapping(value={"/exportXls"}, method={RequestMethod.GET})
    public ModelAndView exportXls(HttpServletRequest request, CodeGenerator codeGenerator) {
        QueryWrapper<CodeGenerator> queryWrapper = QueryGenerator.initQueryWrapper(codeGenerator, request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        ArrayList<CodeGeneratorVO> pageList = new ArrayList<CodeGeneratorVO>();
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        List codeGeneratorList = this.codeGeneratorService.list((Wrapper)queryWrapper);
        for (CodeGenerator temp : codeGeneratorList) {
            CodeGeneratorVO vo = new CodeGeneratorVO();
            BeanUtils.copyProperties((Object)temp, (Object)vo);
            List<CodeGeneratorDetail> codeGeneratorDetailList = this.codeGeneratorDetailService.selectByMainId(temp.getId());
            vo.setCodeGeneratorDetailList(codeGeneratorDetailList);
            List<CodeGeneratorSerial> codeGeneratorSerialList = this.codeGeneratorSerialService.selectByMainId(temp.getId());
            vo.setCodeGeneratorSerialList(codeGeneratorSerialList);
            pageList.add(vo);
        }
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)"\u7f16\u7801\u89c4\u5219");
        mv.addObject("entity", CodeGeneratorVO.class);
        mv.addObject("params", (Object)new ExportParams("\u7f16\u7801\u89c4\u5219\u6570\u636e", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u7f16\u7801\u89c4\u5219", request.getParameter("defineColumnCode")));
        mv.addObject("data", pageList);
        return mv;
    }

    @ApiOperation(value="\u5c06100000\u53f7\u7684\u7f16\u7801\u89c4\u5219\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7-\u6dfb\u52a0", notes="\u5c06100000\u53f7\u7684\u7f16\u7801\u89c4\u5219\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7-\u6dfb\u52a0")
    @GetMapping(value={"/addToEnterprise"})
    public Result<?> addToEnterprise(@RequestParam(value="id") String id) {
        this.codeGeneratorService.addToEnterprise(id);
        return this.commonSuccessResult(3);
    }
}

