/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.uflo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bstek.uflo.model.task.TaskState;
import com.bstek.uflo.utils.IDGenerator;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.uflo.entity.AuditConfig;
import com.els.modules.uflo.mapper.UfloHisTaskMapper;
import com.els.modules.uflo.mapper.UfloTaskMapper;
import com.els.modules.uflo.service.AuditConfigService;
import com.els.modules.uflo.service.AuditOptCallBackService;
import com.els.modules.uflo.service.UfloAuditService;
import com.els.modules.uflo.service.UfloOptService;
import com.els.modules.uflo.vo.AuditInputParamVO;
import com.els.modules.uflo.vo.AuditOutputParamVO;
import com.els.modules.uflo.vo.UfloHisTask;
import com.els.modules.uflo.vo.UfloTask;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UfloAuditServiceImpl
implements UfloAuditService {
    private static final Logger log = LoggerFactory.getLogger(UfloAuditServiceImpl.class);
    @Autowired
    private AuditConfigService auditConfigService;
    @Autowired
    private UfloOptService ufloOptService;
    @Autowired
    private UfloTaskMapper ufloTaskMapper;
    @Autowired
    private UfloHisTaskMapper ufloHisTaskMapper;
    @Autowired
    private ElsSubAccountService elsSubAccountService;

    @Override
    @Transactional(value="hibernateTransactionManager", rollbackFor={RuntimeException.class})
    public void submit(AuditInputParamVO auditVO) {
        AuditConfig config = this.checkParamAndGetConfig(auditVO);
        auditVO.setProcessName(config.getProcessName());
        AuditOutputParamVO outputParamVO = this.ufloOptService.submit(auditVO);
        AuditOptCallBackService callBackService = (AuditOptCallBackService)SpringContextUtils.getBean((String)config.getBeanName());
        callBackService.startCallBack(auditVO, outputParamVO);
    }

    @Override
    @Transactional(value="hibernateTransactionManager", rollbackFor={RuntimeException.class})
    public void complete(AuditInputParamVO auditVO) {
        AuditConfig config = this.checkParamAndGetConfig(auditVO);
        auditVO.setProcessName(config.getProcessName());
        AuditOutputParamVO outputParamVO = this.ufloOptService.complete(auditVO);
        AuditOptCallBackService callBackService = (AuditOptCallBackService)SpringContextUtils.getBean((String)config.getBeanName());
        callBackService.completeCallBack(auditVO, outputParamVO);
    }

    @Override
    @Transactional(value="hibernateTransactionManager", rollbackFor={RuntimeException.class})
    public void cancel(AuditInputParamVO auditVO) {
        AuditConfig config = this.checkParamAndGetConfig(auditVO);
        auditVO.setProcessName(config.getProcessName());
        AuditOutputParamVO outputParamVO = this.ufloOptService.cancel(auditVO);
        AuditOptCallBackService callBackService = (AuditOptCallBackService)SpringContextUtils.getBean((String)config.getBeanName());
        callBackService.cancelCallBack(auditVO, outputParamVO);
    }

    @Override
    @Transactional(value="hibernateTransactionManager", rollbackFor={RuntimeException.class})
    public void reject(AuditInputParamVO auditVO) {
        AuditConfig config = this.checkParamAndGetConfig(auditVO);
        auditVO.setProcessName(config.getProcessName());
        AuditOutputParamVO outputParamVO = this.ufloOptService.reject(auditVO);
        AuditOptCallBackService callBackService = (AuditOptCallBackService)SpringContextUtils.getBean((String)config.getBeanName());
        callBackService.rejectCallBack(auditVO, outputParamVO);
    }

    private AuditConfig checkParamAndGetConfig(AuditInputParamVO auditVO) {
        AuditConfig config;
        if (StringUtils.isEmpty((CharSequence)auditVO.getBusinessType())) {
            throw new ELSBootException("businessType" + I18nUtil.translate((String)"i18n_alert_WWWWWWWWWxOLVW_c2c7a97", (String)"\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (StringUtils.isEmpty((CharSequence)auditVO.getBusinessId())) {
            throw new ELSBootException("businessId" + I18nUtil.translate((String)"i18n_alert_WWWWWWWWWxOLVW_c2c7a97", (String)" \u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.eq(AuditConfig::getBusinessType, (Object)auditVO.getBusinessType());
        List configList = this.auditConfigService.list((Wrapper)queryWrapper);
        if (configList.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq(BaseEntity::getElsAccount, (Object)"100000");
            queryWrapper.eq(AuditConfig::getBusinessType, (Object)auditVO.getBusinessType());
            configList = this.auditConfigService.list((Wrapper)queryWrapper);
            if (configList.isEmpty()) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VWERUzAcW_aaa95027", (String)"\u8bf7\u5148\u914d\u7f6e\u5ba1\u6279\u7c7b\u578b\uff01"));
            }
        }
        if (StringUtils.isEmpty((CharSequence)(config = (AuditConfig)((Object)configList.get(0))).getProcessName())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UzERNSWWWWWWWWWWWWWxOLVW_e05e1c99", (String)"\u5ba1\u6279\u914d\u7f6e\u9519\u8bef\uff01${0} \u4e0d\u80fd\u4e3a\u7a7a\uff01", (String[])new String[]{"ProcessName"}));
        }
        if (StringUtils.isEmpty((CharSequence)config.getBeanName())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UzERNSWWWWWWWWWWWWWxOLVW_e05e1c99", (String)"\u5ba1\u6279\u914d\u7f6e\u9519\u8bef\uff01${0} \u4e0d\u80fd\u4e3a\u7a7a\uff01", (String[])new String[]{"BeanName"}));
        }
        return config;
    }

    @Override
    public IPage<UfloTask> todoPagelist(UfloTask task) {
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        task.setAssignee(user.getElsAccount() + "\\_" + user.getSubAccount() + "\\_");
        task.setState(TaskState.Created.name());
        List<UfloTask> list = this.ufloTaskMapper.findPageList(task);
        int count = this.ufloTaskMapper.findPageListCount(task);
        Page page = new Page((long)task.getFromIndex().intValue(), (long)task.getPageSize().intValue());
        page.setRecords(list);
        page.setSize((long)count);
        page.setTotal((long)count);
        return page;
    }

    @Override
    public IPage<UfloHisTask> donePagelist(UfloHisTask task) {
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        task.setAssignee(user.getElsAccount() + "\\_" + user.getSubAccount() + "\\_");
        List<UfloHisTask> list = this.ufloHisTaskMapper.findPageList(task);
        int count = this.ufloHisTaskMapper.findPageListCount(task);
        Page page = new Page((long)task.getFromIndex().intValue(), (long)task.getPageSize().intValue());
        page.setRecords(list);
        page.setSize((long)count);
        page.setTotal((long)count);
        return page;
    }

    @Override
    public IPage<UfloHisTask> auditHislist(UfloHisTask task) {
        List<UfloHisTask> list = this.ufloHisTaskMapper.findPageList(task);
        int count = this.ufloHisTaskMapper.findPageListCount(task);
        Page page = new Page((long)task.getFromIndex().intValue(), (long)task.getPageSize().intValue());
        page.setRecords(list);
        page.setSize((long)count);
        page.setTotal((long)count);
        return page;
    }

    @Override
    @Transactional
    public void deliverTo(UfloTask task) {
        String receiveId = task.getReceiveId();
        ElsSubAccount sourceAccount = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)SysUtil.getLoginUser().getId()));
        ElsSubAccount targetAccount = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)receiveId));
        this.optDeliverTo(task, sourceAccount, targetAccount);
    }

    @Override
    public void optDeliverTo(UfloTask task, ElsSubAccount sourceAccount, ElsSubAccount targetAccount) {
        String option = sourceAccount.getRealname() + " \u8f6c\u529e\u7ed9 " + targetAccount.getRealname();
        UfloHisTask hisTask = new UfloHisTask();
        BeanUtils.copyProperties((Object)task, (Object)hisTask);
        hisTask.setId(IDGenerator.getInstance().nextId());
        hisTask.setTaskId(task.getTaskId());
        hisTask.setEndDate(new Date());
        hisTask.setState("deliverTo");
        hisTask.setType(task.getType());
        hisTask.setOpinion(option);
        this.ufloHisTaskMapper.insert(hisTask);
        task.setAssignee(targetAccount.getElsAccount() + "_" + targetAccount.getSubAccount() + "_" + targetAccount.getRealname());
        this.ufloTaskMapper.updateAssigneeById(task);
    }
}

