/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.uflo.service.impl;

import com.bstek.uflo.model.task.TaskState;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.AccountDeliverToService;
import com.els.modules.uflo.mapper.UfloTaskMapper;
import com.els.modules.uflo.service.UfloAuditService;
import com.els.modules.uflo.vo.UfloTask;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TodoDeliverToServiceImpl
implements AccountDeliverToService {
    @Autowired
    private UfloTaskMapper ufloTaskMapper;
    @Autowired
    private UfloAuditService ufloAuditService;

    public void deliverTo(ElsSubAccount sourceAccount, ElsSubAccount targetAccount) {
        UfloTask task = new UfloTask();
        task.setAssignee(sourceAccount.getElsAccount() + "_" + sourceAccount.getSubAccount() + "_" + sourceAccount.getRealname());
        task.setState(TaskState.Created.name());
        task.setFromIndex(0);
        task.setPageSize(Integer.MAX_VALUE);
        List<UfloTask> list = this.ufloTaskMapper.findPageList(task);
        for (UfloTask ufloTask : list) {
            this.ufloAuditService.optDeliverTo(ufloTask, sourceAccount, targetAccount);
        }
    }
}

