/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.compute;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.compute.ValueCompute;
import com.bstek.ureport.definition.value.ExpressionValue;
import com.bstek.ureport.definition.value.ValueType;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.ExpressionUtils;
import com.bstek.ureport.expression.function.Function;
import com.bstek.ureport.expression.function.page.PageFunction;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.expr.BaseExpression;
import com.bstek.ureport.expression.model.expr.ExpressionBlock;
import com.bstek.ureport.expression.model.expr.FunctionExpression;
import com.bstek.ureport.expression.model.expr.JoinExpression;
import com.bstek.ureport.expression.model.expr.ifelse.ElseExpression;
import com.bstek.ureport.expression.model.expr.ifelse.ElseIfExpression;
import com.bstek.ureport.expression.model.expr.ifelse.ExpressionCondition;
import com.bstek.ureport.expression.model.expr.ifelse.ExpressionConditionList;
import com.bstek.ureport.expression.model.expr.ifelse.IfExpression;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.List;

public class ExpressionValueCompute
implements ValueCompute {
    public List<BindData> compute(Cell cell, Context context) {
        boolean hasPageFun;
        ExpressionValue exprValue = (ExpressionValue)cell.getValue();
        Expression expr = exprValue.getExpression();
        ArrayList<BindData> list = new ArrayList<BindData>();
        if (!context.isDoPaging() && (hasPageFun = this.hasPageFunction(expr))) {
            cell.setExistPageFunction(true);
            context.addExistPageFunctionCells(cell);
            return list;
        }
        ExpressionData data = expr.execute(cell, cell, context);
        if (data instanceof BindDataListExpressionData) {
            BindDataListExpressionData exprData = (BindDataListExpressionData)data;
            return exprData.getData();
        }
        Object obj = data.getData();
        if (obj instanceof List) {
            List listData = (List)obj;
            for (Object o : listData) {
                list.add(new BindData(o));
            }
        } else if (obj != null) {
            list.add(new BindData(obj));
        }
        return list;
    }

    private boolean hasPageFunction(Expression expr) {
        block17: {
            block18: {
                List baseExpressionList;
                block16: {
                    boolean has;
                    List conditionList;
                    if (expr == null) {
                        return false;
                    }
                    if (!(expr instanceof IfExpression)) break block16;
                    IfExpression ifExpr = (IfExpression)expr;
                    ExpressionConditionList exprConditionList = ifExpr.getConditionList();
                    if (exprConditionList != null && (conditionList = exprConditionList.getConditions()) != null) {
                        for (ExpressionCondition exprCondition : conditionList) {
                            Expression leftExpression = exprCondition.getLeft();
                            has = this.hasPageFunction(leftExpression);
                            if (has) {
                                return true;
                            }
                            Expression rightExpression = exprCondition.getRight();
                            has = this.hasPageFunction(rightExpression);
                            if (!has) continue;
                            return true;
                        }
                    }
                    if (has = this.hasPageFunction((Expression)ifExpr.getExpression())) {
                        return true;
                    }
                    ElseExpression elseExpr = ifExpr.getElseExpression();
                    if (elseExpr != null && (has = this.hasPageFunction((Expression)elseExpr.getExpression()))) {
                        return true;
                    }
                    List elseIfList = ifExpr.getElseIfExpressions();
                    if (elseIfList == null || elseIfList.size() == 0) {
                        return false;
                    }
                    for (ElseIfExpression elseIfExpr : elseIfList) {
                        has = this.hasPageFunction((Expression)elseIfExpr.getExpression());
                        if (!has) continue;
                        return true;
                    }
                    break block17;
                }
                if (!(expr instanceof JoinExpression) && !(expr instanceof FunctionExpression)) break block18;
                if (expr instanceof FunctionExpression) {
                    String name = ((FunctionExpression)expr).getName();
                    Function fun = (Function)ExpressionUtils.getFunctions().get(name);
                    if (fun == null) {
                        throw new ReportComputeException("Function [" + (String)name + "] not exist.");
                    }
                    if (fun instanceof PageFunction) {
                        return true;
                    }
                    baseExpressionList = ((FunctionExpression)expr).getExpressions();
                } else {
                    baseExpressionList = ((JoinExpression)expr).getExpressions();
                }
                if (baseExpressionList == null || baseExpressionList.size() == 0) {
                    return false;
                }
                for (BaseExpression baseExpr : baseExpressionList) {
                    boolean has = this.hasPageFunction((Expression)baseExpr);
                    if (!has) continue;
                    return true;
                }
                break block17;
            }
            if (!(expr instanceof ExpressionBlock)) break block17;
            List expressionList = ((ExpressionBlock)expr).getExpressionList();
            if (expressionList == null || expressionList.size() == 0) {
                return false;
            }
            for (Expression expression : expressionList) {
                boolean has = this.hasPageFunction(expression);
                if (!has) continue;
                return true;
            }
        }
        return false;
    }

    public ValueType type() {
        return ValueType.expression;
    }
}

