/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.designer;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.console.RenderPageServletAction;
import com.bstek.ureport.console.designer.DataResult;
import com.bstek.ureport.console.exception.ReportDesignException;
import com.bstek.ureport.definition.dataset.Field;
import com.bstek.ureport.definition.datasource.BuildinDatasource;
import com.bstek.ureport.definition.datasource.DataType;
import com.bstek.ureport.expression.ExpressionUtils;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.utils.ProcedureUtils;
import com.els.config.mybatis.TenantContext;
import com.els.config.mybatis.UreportTenantParser;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.jdbc.support.JdbcUtils;

public class DatasourceServletAction
extends RenderPageServletAction {
    private static final Logger log = LoggerFactory.getLogger(DatasourceServletAction.class);
    public static final String DB_TYPE_ORACLE = "oracle";
    public static final int PAGE_MAX = 500;
    public static final String DB_JDBC = "jdbc";
    public static final String SQL_FOR_USER_PATTERN = "\\$\\{.*?\\}";

    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        }
    }

    public void loadBuildinDatasources(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ArrayList<String> datasources = new ArrayList<String>();
        for (BuildinDatasource datasource : Utils.getBuildinDatasources()) {
            datasources.add(datasource.name());
        }
        this.writeObjectToJson(resp, datasources);
    }

    public void loadMethods(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String beanId = req.getParameter("beanId");
        Object obj = this.applicationContext.getBean(beanId);
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        ArrayList<String> result = new ArrayList<String>();
        Method[] var8 = methods;
        int var9 = methods.length;
        for (int var10 = 0; var10 < var9; ++var10) {
            Method method = var8[var10];
            Class<?>[] types = method.getParameterTypes();
            if (types.length != 3) continue;
            Class<?> typeClass1 = types[0];
            Class<?> typeClass2 = types[1];
            Class<?> typeClass3 = types[2];
            if (!String.class.isAssignableFrom(typeClass1) || !String.class.isAssignableFrom(typeClass2) || !Map.class.isAssignableFrom(typeClass3)) continue;
            result.add(method.getName());
        }
        this.writeObjectToJson(resp, result);
    }

    public void buildClass(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String clazz = req.getParameter("clazz");
        ArrayList<Field> result = new ArrayList<Field>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            Class<?> targetClass = Class.forName(clazz);
            PropertyDescriptor[] var7 = propertyDescriptors = PropertyUtils.getPropertyDescriptors(targetClass);
            int var8 = propertyDescriptors.length;
            for (int var9 = 0; var9 < var8; ++var9) {
                PropertyDescriptor pd = var7[var9];
                String name = pd.getName();
                if ("class".equals(name)) continue;
                result.add(new Field(name));
            }
            this.writeObjectToJson(resp, result);
        }
        catch (Exception var12) {
            throw new ReportDesignException(var12);
        }
    }

    public void buildDatabaseTables(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = this.buildConnection(req);
            DatabaseMetaData metaData = conn.getMetaData();
            String url = metaData.getURL();
            String schema = null;
            if (url.toLowerCase().contains(DB_TYPE_ORACLE)) {
                schema = metaData.getUserName();
            }
            ArrayList tables = new ArrayList();
            rs = metaData.getTables(null, schema, "%", new String[]{"TABLE", "VIEW"});
            while (rs.next()) {
                if (!rs.getString("TABLE_NAME").toUpperCase().startsWith("SRM_")) continue;
                HashMap<String, String> table = new HashMap<String, String>(16);
                table.put("name", rs.getString("TABLE_NAME"));
                table.put("type", rs.getString("TABLE_TYPE"));
                tables.add(table);
            }
            this.writeObjectToJson(resp, tables);
        }
        catch (Exception var13) {
            try {
                throw new ServletException((Throwable)var13);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeConnection((Connection)conn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet((ResultSet)rs);
        JdbcUtils.closeConnection((Connection)conn);
    }

    public void buildFields(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sql = req.getParameter("sql");
        String parameters = req.getParameter("parameters");
        Connection conn = null;
        final ArrayList fields = new ArrayList();
        try {
            conn = this.buildConnection(req);
            Map<String, Object> map = this.buildParameters(parameters);
            sql = this.parseSql(sql, map);
            if (ProcedureUtils.isProcedure((String)sql)) {
                List fieldsList = ProcedureUtils.procedureColumnsQuery((String)sql, map, (Connection)conn);
                fields.addAll(fieldsList);
            } else {
                SingleConnectionDataSource dataSource = new SingleConnectionDataSource(conn, false);
                NamedParameterJdbcTemplate jdbc = new NamedParameterJdbcTemplate((DataSource)dataSource);
                PreparedStatementCreator statementCreator = this.getPreparedStatementCreator(sql, (SqlParameterSource)new MapSqlParameterSource(map));
                jdbc.getJdbcOperations().execute(statementCreator, (PreparedStatementCallback)new PreparedStatementCallback<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                        ResultSet rs = null;
                        try {
                            Object var10;
                            rs = ps.executeQuery();
                            ResultSetMetaData metadata = rs.getMetaData();
                            int columnCount = metadata.getColumnCount();
                            for (int i = 0; i < columnCount; ++i) {
                                String columnName = metadata.getColumnLabel(i + 1);
                                fields.add(new Field(columnName));
                            }
                            Object var6_7 = var10 = null;
                            return var6_7;
                        }
                        finally {
                            JdbcUtils.closeResultSet((ResultSet)rs);
                        }
                    }
                });
            }
            this.writeObjectToJson(resp, fields);
        }
        catch (Exception var14) {
            throw new ReportDesignException(var14);
        }
        finally {
            JdbcUtils.closeConnection((Connection)conn);
        }
    }

    protected PreparedStatementCreator getPreparedStatementCreator(String sql, SqlParameterSource paramSource) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement((String)sql);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters((ParsedSql)parsedSql, (SqlParameterSource)paramSource);
        Object[] params = NamedParameterUtils.buildValueArray((ParsedSql)parsedSql, (SqlParameterSource)paramSource, (List)null);
        List declaredParameters = NamedParameterUtils.buildSqlParameterList((ParsedSql)parsedSql, (SqlParameterSource)paramSource);
        PreparedStatementCreatorFactory pscf = new PreparedStatementCreatorFactory(sqlToUse, declaredParameters);
        return pscf.newPreparedStatementCreator(params);
    }

    public void previewData(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sql = req.getParameter("sql");
        String parameters = req.getParameter("parameters");
        Map<String, Object> map = this.buildParameters(parameters);
        sql = this.parseSql(sql, map);
        Connection conn = null;
        try {
            int size;
            conn = this.buildConnection(req);
            List list = null;
            log.info("DatasourceServletAction.previewData" + sql);
            if (ProcedureUtils.isProcedure((String)sql)) {
                list = ProcedureUtils.procedureQuery((String)sql, map, (Connection)conn);
            } else {
                String tenantId = TenantContext.getTenant();
                log.info("\u79df\u6237ID" + tenantId);
                sql = UreportTenantParser.addTenantCondition(sql, tenantId);
                Utils.logToConsole((String)("DESIGN SQL2:" + sql));
                SingleConnectionDataSource dataSource = new SingleConnectionDataSource(conn, false);
                NamedParameterJdbcTemplate jdbc = new NamedParameterJdbcTemplate((DataSource)dataSource);
                list = jdbc.queryForList(sql, map);
            }
            int currentTotal = size = list.size();
            if (size > 500) {
                currentTotal = 500;
            }
            ArrayList ls = new ArrayList();
            for (int i = 0; i < currentTotal; ++i) {
                ls.add(list.get(i));
            }
            DataResult result = new DataResult();
            ArrayList<String> fields = new ArrayList<String>();
            if (size > 0) {
                Map item = (Map)list.get(0);
                for (String name : item.keySet()) {
                    fields.add(name);
                }
            }
            result.setFields(fields);
            result.setCurrentTotal(currentTotal);
            result.setData(ls);
            result.setTotal(size);
            this.writeObjectToJson(resp, result);
        }
        catch (Exception var23) {
            throw new ServletException((Throwable)var23);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException var22) {
                    var22.printStackTrace();
                }
            }
        }
    }

    private String parseSql(String sql, Map<String, Object> parameters) {
        sql = sql.trim();
        Context context = new Context(this.applicationContext, parameters);
        if (sql.startsWith("${") && sql.endsWith("}")) {
            sql = sql.substring(2, sql.length() - 1);
            Expression expr = ExpressionUtils.parseExpression((String)sql);
            sql = this.executeSqlExpr(expr, context);
            return sql;
        }
        String sqlForUse = sql;
        Pattern pattern = Pattern.compile(SQL_FOR_USER_PATTERN);
        Matcher matcher = pattern.matcher(sql);
        while (matcher.find()) {
            String substr = matcher.group();
            String sqlExpr = substr.substring(2, substr.length() - 1);
            Expression expr = ExpressionUtils.parseExpression((String)sqlExpr);
            String result = this.executeSqlExpr(expr, context);
            sqlForUse = sqlForUse.replace(substr, result);
        }
        Utils.logToConsole((String)("DESIGN SQL:" + sqlForUse));
        return sqlForUse;
    }

    private String executeSqlExpr(Expression sqlExpr, Context context) {
        ObjectExpressionData data;
        Object obj;
        String sqlForUse = null;
        ExpressionData exprData = sqlExpr.execute((Cell)null, (Cell)null, context);
        if (exprData instanceof ObjectExpressionData && (obj = (data = (ObjectExpressionData)exprData).getData()) != null) {
            String s = obj.toString();
            sqlForUse = s = s.replaceAll("\\\\", "");
        }
        return sqlForUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username = req.getParameter("username");
        String password = req.getParameter("password");
        String driver = req.getParameter("driver");
        String url = req.getParameter("url");
        Connection conn = null;
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        try {
            Class.forName(driver);
            conn = DriverManager.getConnection(url, username, password);
            map.put("result", true);
        }
        catch (Exception var18) {
            map.put("error", var18.toString());
            map.put("result", false);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException var17) {
                    var17.printStackTrace();
                }
            }
        }
        this.writeObjectToJson(resp, map);
    }

    private Map<String, Object> buildParameters(String parameters) throws IOException, JsonParseException, JsonMappingException {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (StringUtils.isBlank((CharSequence)parameters)) {
            return map;
        }
        ObjectMapper mapper = new ObjectMapper();
        List list = (List)mapper.readValue(parameters, ArrayList.class);
        for (Map param : list) {
            String name = param.get("name").toString();
            DataType type = DataType.valueOf((String)param.get("type").toString());
            String defaultValue = (String)param.get("defaultValue");
            if (defaultValue != null && !defaultValue.equals("")) {
                map.put(name, type.parse((Object)defaultValue));
                continue;
            }
            switch (type) {
                case Boolean: {
                    map.put(name, false);
                    break;
                }
                case Date: {
                    map.put(name, new Date());
                    break;
                }
                case Float: {
                    map.put(name, new Float(0.0f));
                    break;
                }
                case Integer: {
                    map.put(name, 0);
                    break;
                }
                case String: {
                    if (defaultValue != null && defaultValue.equals("")) {
                        map.put(name, "");
                        break;
                    }
                    map.put(name, "null");
                    break;
                }
                case List: {
                    map.put(name, new ArrayList());
                    break;
                }
            }
        }
        return map;
    }

    private Connection buildConnection(HttpServletRequest req) throws Exception {
        String type = req.getParameter("type");
        if (DB_JDBC.equals(type)) {
            String name = req.getParameter("username");
            String password = req.getParameter("password");
            String driver = req.getParameter("driver");
            String url = req.getParameter("url");
            Class.forName(driver);
            Connection conn = DriverManager.getConnection(url, name, password);
            return conn;
        }
        String name = req.getParameter("name");
        Connection conn = Utils.getBuildinConnection((String)name);
        if (conn == null) {
            throw new ReportDesignException("Buildin datasource [" + name + "] not exist.");
        }
        return conn;
    }

    public String url() {
        return "/datasource";
    }
}

