/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.definition.dataset;

import com.alibaba.fastjson.JSON;
import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.Dataset;
import com.bstek.ureport.definition.dataset.DatasetDefinition;
import com.bstek.ureport.definition.dataset.Field;
import com.bstek.ureport.definition.dataset.Parameter;
import com.bstek.ureport.definition.datasource.DataType;
import com.bstek.ureport.expression.ExpressionUtils;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.utils.ProcedureUtils;
import com.els.config.mybatis.TenantContext;
import com.els.config.mybatis.UreportTenantParser;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class SqlDatasetDefinition
implements DatasetDefinition {
    private static final Logger log = LoggerFactory.getLogger(SqlDatasetDefinition.class);
    private static final long serialVersionUID = -1134526105416805870L;
    private static final Pattern pattern = Pattern.compile("\\$\\{.*?\\}");
    private String name;
    private String sql;
    private List<Parameter> parameters;
    private List<Field> fields;
    private Expression sqlExpression;

    public Dataset buildDataset(Map<String, Object> parameterMap, Connection conn) {
        String sqlForUse = this.sql;
        Context context = new Context(null, parameterMap);
        if (this.sqlExpression != null) {
            sqlForUse = this.executeSqlExpr(this.sqlExpression, context);
        } else {
            Matcher matcher = pattern.matcher(sqlForUse);
            while (matcher.find()) {
                String substr = matcher.group();
                String sqlExpr = substr.substring(2, substr.length() - 1);
                Expression expr = ExpressionUtils.parseExpression((String)sqlExpr);
                String result = this.executeSqlExpr(expr, context);
                sqlForUse = sqlForUse.replace(substr, result);
            }
        }
        log.info("\u52a0\u8f7d\u524dSql:" + sqlForUse);
        Utils.logToConsole((String)("RUNTIME SQL:" + sqlForUse));
        Map<String, Object> pmap = this.buildParameters(parameterMap);
        if (ProcedureUtils.isProcedure((String)sqlForUse)) {
            List result = ProcedureUtils.procedureQuery((String)sqlForUse, pmap, (Connection)conn);
            return new Dataset(this.name, result);
        }
        String tenantId = TenantContext.getTenant();
        log.info("\u79df\u6237id" + tenantId);
        sqlForUse = UreportTenantParser.addTenantCondition(sqlForUse, tenantId);
        Utils.logToConsole((String)("RUNTIME SQL2:" + sqlForUse));
        log.info("\u52a0\u8f7d\u540eSql:" + sqlForUse);
        SingleConnectionDataSource datasource = new SingleConnectionDataSource(conn, false);
        NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate((DataSource)datasource);
        List list = jdbcTemplate.queryForList(sqlForUse, pmap);
        log.info("\u6267\u884c\u6570\u636e: " + JSON.toJSONString((Object)list));
        return new Dataset(this.name, list);
    }

    private String executeSqlExpr(Expression sqlExpr, Context context) {
        ObjectExpressionData data;
        Object obj;
        String sqlForUse = null;
        ExpressionData exprData = sqlExpr.execute(null, null, context);
        if (exprData instanceof ObjectExpressionData && (obj = (data = (ObjectExpressionData)exprData).getData()) != null) {
            String s = obj.toString();
            sqlForUse = s = s.replaceAll("\\\\", "");
        }
        return sqlForUse;
    }

    private Map<String, Object> buildParameters(Map<String, Object> params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Parameter param : this.parameters) {
            String name = param.getName();
            DataType datatype = param.getType();
            Object value = param.getDefaultValue();
            if (params != null && params.containsKey(name)) {
                value = params.get(name);
            }
            map.put(name, datatype.parse(value));
        }
        return map;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setSqlExpression(Expression sqlExpression) {
        this.sqlExpression = sqlExpression;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }
}

