/*
 * Decompiled with CFR 0.152.
 */
package com.els.config.mybatis;

import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TableNameUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class ElsJimuTenantHandler {
    private static final Logger log = LoggerFactory.getLogger(ElsJimuTenantHandler.class);
    private static List<String> tenantTablePrefix = new ArrayList<String>();
    private static String token;
    private static List<String> notTenantTable;
    private static final String NOT_TENANT_TABLES = "";

    public static boolean checkNeedTeant(String sql) {
        try {
            List<String> list = TableNameUtils.parseSqlRefTables(sql);
            return ElsJimuTenantHandler.checkTables(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean checkTables(List<String> tableNameList) {
        for (String s : tableNameList) {
            for (String prefix : tenantTablePrefix) {
                if (!s.toLowerCase().contains(prefix) || notTenantTable.contains(s.toLowerCase())) continue;
                return false;
            }
        }
        return true;
    }

    static {
        notTenantTable = new ArrayList<String>();
        Environment env = (Environment)SpringContextUtils.getBean(Environment.class);
        String tenantTablePrefixString = env.getProperty("els.tenant-table-prefix", "purchase_,sale_");
        tenantTablePrefix = Arrays.asList(tenantTablePrefixString.split(","));
        String notTenantTableString = env.getProperty("els.not-tenant-table", NOT_TENANT_TABLES);
        notTenantTable = Arrays.asList(notTenantTableString.split(","));
    }
}

