/*
 * Decompiled with CFR 0.152.
 */
package com.els.config.mybatis;

import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.config.mybatis.TenantContext;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MybatisInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Field[] fields;
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        String sqlId = mappedStatement.getId();
        log.debug("------sqlId------" + sqlId);
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        Object parameter = invocation.getArgs()[1];
        log.debug("------sqlCommandType------" + sqlCommandType);
        if (parameter == null) {
            return invocation.proceed();
        }
        if (SqlCommandType.INSERT == sqlCommandType) {
            String tenantId = TenantContext.getTenant();
            if (parameter instanceof Map) {
                Map map = (Map)parameter;
                if (!map.containsKey("list")) {
                    fields = ConvertUtils.getAllFields((Object)parameter);
                    this.setFields(fields, parameter);
                }
            } else {
                fields = ConvertUtils.getAllFields((Object)parameter);
                this.setFields(fields, parameter);
            }
        }
        if (SqlCommandType.UPDATE == sqlCommandType) {
            fields = null;
            if (parameter instanceof MapperMethod.ParamMap) {
                MapperMethod.ParamMap p = (MapperMethod.ParamMap)parameter;
                if ((parameter = p.containsKey((Object)"et") ? p.get((Object)"et") : p.get((Object)"param1")) == null) {
                    return invocation.proceed();
                }
                fields = ConvertUtils.getAllFields((Object)parameter);
            } else {
                fields = ConvertUtils.getAllFields((Object)parameter);
            }
            for (Field field : fields) {
                log.debug("------field.name------" + field.getName());
                try {
                    LoginUser sysUser = null;
                    try {
                        sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if ("updateBy".equals(field.getName()) && sysUser != null) {
                        String updateBy = sysUser.getSubAccount();
                        field.setAccessible(true);
                        field.set(parameter, updateBy);
                        field.setAccessible(false);
                    }
                    if ("elsAccount".equals(field.getName())) {
                        field.setAccessible(true);
                        Object local_tenantId = field.get(parameter);
                        field.setAccessible(false);
                        if (local_tenantId == null || local_tenantId.equals("")) {
                            String tenantId = "0";
                            if (sysUser != null) {
                                tenantId = TenantContext.getTenant();
                            }
                            if (ConvertUtils.isNotEmpty((Object)tenantId)) {
                                field.setAccessible(true);
                                field.set(parameter, tenantId);
                                field.setAccessible(false);
                            }
                        }
                    }
                    if (!"updateTime".equals(field.getName())) continue;
                    field.setAccessible(true);
                    field.set(parameter, new Date());
                    field.setAccessible(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return invocation.proceed();
    }

    private void setFields(Field[] fields, Object parameter) {
        for (Field field : fields) {
            log.debug("------field.name------" + field.getName());
            try {
                Object local_createDate;
                String createBy;
                Object local_createBy;
                LoginUser sysUser = null;
                try {
                    sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
                }
                catch (Exception e) {
                    sysUser = null;
                }
                if ("elsAccount".equals(field.getName())) {
                    field.setAccessible(true);
                    Object local_tenantId = field.get(parameter);
                    field.setAccessible(false);
                    if (local_tenantId == null || local_tenantId.equals("")) {
                        String tenantId = "0";
                        if (sysUser != null) {
                            tenantId = sysUser.getElsAccount();
                        }
                        if (ConvertUtils.isNotEmpty((Object)tenantId)) {
                            field.setAccessible(true);
                            field.set(parameter, tenantId);
                            field.setAccessible(false);
                        }
                    }
                }
                if ("createBy".equals(field.getName())) {
                    field.setAccessible(true);
                    local_createBy = field.get(parameter);
                    field.setAccessible(false);
                    if (local_createBy == null || local_createBy.equals("")) {
                        createBy = "els";
                        if (sysUser != null) {
                            createBy = sysUser.getSubAccount();
                        }
                        if (ConvertUtils.isNotEmpty((Object)createBy)) {
                            field.setAccessible(true);
                            field.set(parameter, createBy);
                            field.setAccessible(false);
                        }
                    }
                }
                if ("updateBy".equals(field.getName())) {
                    field.setAccessible(true);
                    local_createBy = field.get(parameter);
                    field.setAccessible(false);
                    if (local_createBy == null || local_createBy.equals("")) {
                        createBy = "els";
                        if (sysUser != null) {
                            createBy = sysUser.getSubAccount();
                        }
                        if (ConvertUtils.isNotEmpty((Object)createBy)) {
                            field.setAccessible(true);
                            field.set(parameter, createBy);
                            field.setAccessible(false);
                        }
                    }
                }
                if ("createTime".equals(field.getName())) {
                    field.setAccessible(true);
                    local_createDate = field.get(parameter);
                    field.setAccessible(false);
                    if (local_createDate == null || local_createDate.equals("")) {
                        field.setAccessible(true);
                        field.set(parameter, new Date());
                        field.setAccessible(false);
                    }
                }
                if ("updateTime".equals(field.getName())) {
                    field.setAccessible(true);
                    local_createDate = field.get(parameter);
                    field.setAccessible(false);
                    if (local_createDate == null || local_createDate.equals("")) {
                        field.setAccessible(true);
                        field.set(parameter, new Date());
                        field.setAccessible(false);
                    }
                }
                if (!"sysOrgCode".equals(field.getName())) continue;
                field.setAccessible(true);
                Object local_sysOrgCode = field.get(parameter);
                field.setAccessible(false);
                if (local_sysOrgCode != null && !local_sysOrgCode.equals("")) continue;
                String sysOrgCode = "";
                if (sysUser != null) {
                    sysOrgCode = sysUser.getOrgCode();
                }
                if (!ConvertUtils.isNotEmpty((Object)sysOrgCode)) continue;
                field.setAccessible(true);
                field.set(parameter, sysOrgCode);
                field.setAccessible(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

