/*
 * Decompiled with CFR 0.152.
 */
package com.els.config.mybatis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TableNameUtils {
    private static Pattern p = Pattern.compile("\\s+from\\s+(\\w+)(\\s+|,)(\\w*)|\\s+join\\s+(\\w+)\\s+(\\w*)\\s+on", 2);

    private static String preHandleSql(String sql, boolean removeBrackets) throws Exception {
        sql = sql.contains("\r\n") ? sql.replaceAll("\r\n", "\n") : sql.replaceAll("\r", "\n");
        String[] rows = sql.split("\n");
        StringBuilder sb = new StringBuilder(sql.length());
        for (String row : rows) {
            int indexOfComment = row.indexOf("--");
            if (indexOfComment == -1) {
                sb.append(row).append("\n");
                continue;
            }
            sb.append(row, 0, indexOfComment).append("\n");
        }
        if (removeBrackets) {
            sql = TableNameUtils.removeBrackets(sb);
        }
        return sql.toLowerCase();
    }

    private static String removeBrackets(StringBuilder str) throws Exception {
        ArrayList bracketsContainer = new ArrayList();
        TableNameUtils.collectBrackets(str, 0, bracketsContainer);
        if (bracketsContainer.isEmpty()) {
            return str.toString();
        }
        StringBuilder newStr = new StringBuilder(str.length());
        int groupSize = bracketsContainer.size();
        for (int i = 0; i < groupSize; ++i) {
            int[] currentBrackets = (int[])bracketsContainer.get(i);
            if (i == 0) {
                newStr.append(str.subSequence(0, currentBrackets[0]));
            }
            if (i + 1 == groupSize) {
                newStr.append(str.subSequence(currentBrackets[1] + 1, str.length()));
                continue;
            }
            int[] nextBrackets = (int[])bracketsContainer.get(i + 1);
            newStr.append(str.subSequence(currentBrackets[1] + 1, nextBrackets[0]));
        }
        return newStr.toString();
    }

    private static void collectBrackets(StringBuilder str, int fromIndex, List bracketsContainer) throws Exception {
        int tempLeftBracket;
        int firstLeftBracket;
        int nextLeftBracket = firstLeftBracket = str.indexOf("(", fromIndex + 1);
        if (firstLeftBracket == -1) {
            return;
        }
        int level = 1;
        int nextRightBracket = str.indexOf(")", fromIndex + 1);
        if (nextRightBracket == -1) {
            throw new Exception("\u62ec\u53f7\u4e0d\u5339\u914d");
        }
        int maxLevel = 1000;
        while ((tempLeftBracket = str.indexOf("(", nextLeftBracket + 1)) != -1 && tempLeftBracket <= nextRightBracket) {
            nextLeftBracket = tempLeftBracket;
            if ((nextRightBracket = str.indexOf(")", nextRightBracket + 1)) == -1) {
                throw new Exception("\u62ec\u53f7\u4e0d\u5339\u914d");
            }
            if (++level <= maxLevel) continue;
        }
        if (level >= maxLevel) {
            throw new Exception("\u62ec\u53f7\u5d4c\u5957\u5c42\u7ea7\u8fc7\u591a");
        }
        bracketsContainer.add(new int[]{firstLeftBracket, nextRightBracket});
        TableNameUtils.collectBrackets(str, nextRightBracket, bracketsContainer);
    }

    public static List<String> parseSqlRefTables(String sql) throws Exception {
        ArrayList<String> tableNames = new ArrayList<String>();
        String newSql = StringUtils.replaceAll((String)TableNameUtils.preHandleSql(sql, false), (String)"\n", (String)" ");
        Matcher m = p.matcher(newSql);
        while (m.find()) {
            tableNames.add(m.group());
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String tableName : tableNames) {
            String trimTableName = StringUtils.split((String)tableName, (String)" ")[1].trim();
            if (trimTableName.contains(",")) {
                result.addAll(Arrays.asList(StringUtils.split((String)trimTableName, (String)",")));
                continue;
            }
            result.add(trimTableName);
        }
        return result.parallelStream().distinct().collect(Collectors.toList());
    }

    public static void main(String[] args) throws Exception {
        String data1 = "SELECT dma_t.\"id\", dma_t.\"name\", dma_t.area_border, dma_t.lat_lng, dma_t.level, leak_t.lossf, leak_t.\"day\", leak_t.avgf, leak_t.background_loss, leak_t.nmf, leak_t.normal_use, leak_t.supply FROM la_leak_t leak_t, ( SELECT MAX (dma_id) AS dma_id, MAX (\"day\") AS \"day\" FROM la_leak_t WHERE org_id = ${orgId} GROUP BY dma_id ) recent_t, mdm_dmaarea_m_t dma_t WHERE leak_t.dma_id = recent_t.dma_id AND leak_t.\"day\" = recent_t.\"day\" AND leak_t.dma_id = dma_t.\"id\"";
        List<String> tableNames = TableNameUtils.parseSqlRefTables(data1);
        tableNames.forEach(System.out::println);
    }
}

