/*
 * Decompiled with CFR 0.152.
 */
package com.els.config.mybatis;

import com.els.common.system.vo.LoginUser;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantContext {
    private static final Logger log = LoggerFactory.getLogger(TenantContext.class);
    private static ThreadLocal<String> currentTenant = new ThreadLocal();

    public static void setTenant(String tenant) {
        try {
            Subject subject = SecurityUtils.getSubject();
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            tenant = sysUser.getElsAccount();
            Session session = subject.getSession();
            session.setAttribute((Object)"els_account", (Object)tenant);
        }
        catch (Exception e) {
            currentTenant.set(tenant);
        }
    }

    public static String getTenant() {
        try {
            Subject subject = SecurityUtils.getSubject();
            Session session = subject.getSession();
            log.info("\u83b7\u53d6Session" + session.toString());
            log.info("\u83b7\u53d6Principal" + SecurityUtils.getSubject().getPrincipal());
            if (session.getAttribute((Object)"els_account") == null) {
                LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
                log.info("\u83b7\u53d6LoginUser" + sysUser.toString());
                return sysUser.getElsAccount();
            }
            log.info("\u83b7\u53d6els_account" + session.getAttribute((Object)"els_account").toString());
            return session.getAttribute((Object)"els_account").toString();
        }
        catch (Exception e) {
            return currentTenant.get();
        }
    }

    public static void clear() {
        Subject subject = SecurityUtils.getSubject();
        Session session = subject.getSession();
        session.removeAttribute((Object)"els_account");
        currentTenant.remove();
    }
}

