/*
 * Decompiled with CFR 0.152.
 */
package com.els.config.mybatis;

import com.baomidou.mybatisplus.extension.plugins.tenant.TenantHandler;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.config.ElsTenantHandler;
import com.els.config.mybatis.TenantContext;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.SupportsOldOracleJoinSyntax;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import net.sf.jsqlparser.util.deparser.SelectDeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UreportTenantParser
extends SelectDeParser {
    private static final Logger log = LoggerFactory.getLogger(UreportTenantParser.class);
    private String tenantId;
    private ExpressionVisitor expressionVisitor;
    private TenantHandler tenantHandler;

    public UreportTenantParser(ExpressionVisitor expressionVisitor, StringBuilder buffer, String tenantId) {
        super(expressionVisitor, buffer);
        this.tenantId = tenantId;
        this.expressionVisitor = expressionVisitor;
        this.setTenantHandler((TenantHandler)new ElsTenantHandler());
    }

    private void setTenantHandler(TenantHandler tenantHandler) {
        this.tenantHandler = tenantHandler;
    }

    public static String addTenantCondition(String sql, String tenantId) {
        StringBuilder buffer = new StringBuilder();
        try {
            if (sql.contains("jimu_report") || sql.contains("jimu_report_data_source") || sql.contains("jimu_report_db") || sql.contains("jimu_report_db_field") || sql.contains("jimu_report_db_param") || sql.contains("jimu_report_link") || sql.contains("tmp_report_data_1") || sql.contains("jimu_report_share") || sql.contains("rep_demo_dxtj") || sql.contains("jimu_report_map") || sql.contains("tmp_report_data_income") || sql.contains("jimu_dict") || sql.contains("jimu_dict_item") || sql.contains("els_dict") || sql.contains("els_dict_item") && sql.contains("1=1") || sql.contains("rep_demo_employee") || sql.contains("rep_demo_gongsi") || sql.contains("rep_demo_jianpiao")) {
                if (sql.contains("jimu_report_data_source")) {
                    sql = sql.contains("jrds") ? sql.replace("1=1", "jrds.els_account = '" + TenantContext.getTenant() + "'") : sql.replace("1=1", "els_account = '" + TenantContext.getTenant() + "'");
                } else if (sql.contains("jimu_report_db_field")) {
                    sql = sql.contains("jrdf") ? sql.replace("1=1", "jrdf.els_account = '" + TenantContext.getTenant() + "'") : sql.replace("1=1", "els_account = '" + TenantContext.getTenant() + "'");
                } else if (sql.contains("jimu_report_db_param")) {
                    sql = sql.contains("jrfp") ? sql.replace("1=1", "jrfp.els_account = '" + TenantContext.getTenant() + "'") : sql.replace("1=1", "els_account = '" + TenantContext.getTenant() + "'");
                } else if (sql.contains("jimu_report_db")) {
                    sql = sql.contains("jrd") ? sql.replace("1=1", "jrd.els_account = '" + TenantContext.getTenant() + "'") : sql.replace("1=1", "els_account = '" + TenantContext.getTenant() + "'");
                } else if (sql.contains("jimu_report_link")) {
                    sql = sql.contains("jrl") ? sql.replace("1=1", "jrl.els_account = '" + TenantContext.getTenant() + "'") : sql.replace("1=1", "els_account = '" + TenantContext.getTenant() + "'");
                } else if (sql.contains("jimu_report")) {
                    sql = sql.contains("jr") ? sql.replace("1=1", "jr.els_account = '" + TenantContext.getTenant() + "'") : sql.replace("1=1", "els_account = '" + TenantContext.getTenant() + "'");
                } else if (sql.contains("jimu_dict") || sql.contains("els_dict")) {
                    sql = sql.replace("1=1", "sd.els_account = '" + TenantContext.getTenant() + "'");
                }
                return sql;
            }
            Select select = (Select)CCJSqlParserUtil.parse((String)sql);
            ExpressionDeParser expressionDeParser = new ExpressionDeParser();
            UreportTenantParser deparser = new UreportTenantParser((ExpressionVisitor)expressionDeParser, buffer, tenantId);
            expressionDeParser.setSelectVisitor((SelectVisitor)deparser);
            expressionDeParser.setBuffer(buffer);
            select.getSelectBody().accept((SelectVisitor)deparser);
            log.info("UreportTenantParser.addTenantCondition:" + sql);
        }
        catch (JSQLParserException e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWUhNS_cb789d4c", (String)"sql\u8bed\u6cd5\u9519\u8bef") + (Object)((Object)e));
        }
        return buffer.toString();
    }

    protected void processPlainSelect(PlainSelect plainSelect, boolean addColumn) {
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            if (!this.tenantHandler.doTableFilter(fromTable.getName())) {
                plainSelect.setWhere(this.builderExpression(plainSelect.getWhere(), fromTable));
                if (addColumn) {
                    plainSelect.getSelectItems().add(new SelectExpressionItem((Expression)new Column(this.tenantHandler.getTenantIdColumn())));
                }
            }
        } else {
            this.processFromItem(fromItem);
        }
        List joins = plainSelect.getJoins();
        if (joins != null && joins.size() > 0) {
            joins.forEach(j -> {
                this.processJoin((Join)j);
                this.processFromItem(j.getRightItem());
            });
        }
    }

    public void visit(PlainSelect plainSelect) {
        this.processPlainSelect(plainSelect);
        this.buffer.append(plainSelect.toString());
    }

    protected void processFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (subJoin.getJoinList() != null) {
                subJoin.getJoinList().forEach(this::processJoin);
            }
            if (subJoin.getLeft() != null) {
                this.processFromItem(subJoin.getLeft());
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (!(fromItem instanceof ValuesList) && fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody());
        }
    }

    protected void processJoin(Join join) {
        if (join.getRightItem() instanceof Table) {
            Table fromTable = (Table)join.getRightItem();
            if (this.tenantHandler.doTableFilter(fromTable.getName())) {
                return;
            }
            join.setOnExpression(this.builderExpression(join.getOnExpression(), fromTable));
        }
    }

    protected Expression builderExpression(Expression currentExpression, Table table) {
        InExpression inExp;
        ItemsList rightItems;
        EqualsTo appendExpression;
        Expression tenantExpression = this.tenantHandler.getTenantId(false);
        if (!(tenantExpression instanceof SupportsOldOracleJoinSyntax)) {
            appendExpression = new EqualsTo();
            appendExpression.setLeftExpression((Expression)this.getAliasColumn(table));
            appendExpression.setRightExpression(tenantExpression);
        } else {
            appendExpression = this.processTableAlias4CustomizedTenantIdExpression(tenantExpression, table);
        }
        if (currentExpression == null) {
            return appendExpression;
        }
        if (currentExpression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)currentExpression;
            this.doExpression(binaryExpression.getLeftExpression());
            this.doExpression(binaryExpression.getRightExpression());
        } else if (currentExpression instanceof InExpression && (rightItems = (inExp = (InExpression)currentExpression).getRightItemsList()) instanceof SubSelect) {
            this.processSelectBody(((SubSelect)rightItems).getSelectBody());
        }
        if (currentExpression instanceof OrExpression) {
            return new AndExpression((Expression)new Parenthesis(currentExpression), (Expression)appendExpression);
        }
        return new AndExpression(currentExpression, (Expression)appendExpression);
    }

    protected void doExpression(Expression expression) {
        InExpression inExp;
        ItemsList rightItems;
        if (expression instanceof FromItem) {
            this.processFromItem((FromItem)expression);
        } else if (expression instanceof InExpression && (rightItems = (inExp = (InExpression)expression).getRightItemsList()) instanceof SubSelect) {
            this.processSelectBody(((SubSelect)rightItems).getSelectBody());
        }
    }

    public void processSelectBody(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            if (withItem.getSelectBody() != null) {
                this.processSelectBody(withItem.getSelectBody());
            }
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                operationList.getSelects().forEach(this::processSelectBody);
            }
        }
    }

    protected void processPlainSelect(PlainSelect plainSelect) {
        this.processPlainSelect(plainSelect, false);
    }

    protected Expression processTableAlias4CustomizedTenantIdExpression(Expression expression, Table table) {
        return expression;
    }

    protected Column getAliasColumn(Table table) {
        StringBuilder column = new StringBuilder();
        if (null == table.getAlias()) {
            column.append(table.getName());
        } else {
            column.append(table.getAlias().getName());
        }
        column.append(".");
        column.append(this.tenantHandler.getTenantIdColumn());
        return new Column(column.toString());
    }

    public UreportTenantParser() {
    }

    public UreportTenantParser(String tenantId, ExpressionVisitor expressionVisitor, TenantHandler tenantHandler) {
        this.tenantId = tenantId;
        this.expressionVisitor = expressionVisitor;
        this.tenantHandler = tenantHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UreportTenantParser)) {
            return false;
        }
        UreportTenantParser other = (UreportTenantParser)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$tenantId = this.tenantId;
        String other$tenantId = other.tenantId;
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        ExpressionVisitor this$expressionVisitor = this.expressionVisitor;
        ExpressionVisitor other$expressionVisitor = other.expressionVisitor;
        if (this$expressionVisitor == null ? other$expressionVisitor != null : !this$expressionVisitor.equals(other$expressionVisitor)) {
            return false;
        }
        TenantHandler this$tenantHandler = this.tenantHandler;
        TenantHandler other$tenantHandler = other.tenantHandler;
        return !(this$tenantHandler == null ? other$tenantHandler != null : !this$tenantHandler.equals(other$tenantHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UreportTenantParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $tenantId = this.tenantId;
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        ExpressionVisitor $expressionVisitor = this.expressionVisitor;
        result = result * 59 + ($expressionVisitor == null ? 43 : $expressionVisitor.hashCode());
        TenantHandler $tenantHandler = this.tenantHandler;
        result = result * 59 + ($tenantHandler == null ? 43 : $tenantHandler.hashCode());
        return result;
    }
}

