/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dashboard.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.BeanUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.dashboard.entity.ChartData;
import com.els.modules.dashboard.excel.CharDataExportServiceImpl;
import com.els.modules.dashboard.service.ChartDataService;
import com.els.modules.dashboard.vo.ChartDataVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u56fe\u8868\u6570\u636e"})
@RestController
@RequestMapping(value={"/dashboard/chartData"})
public class ChartDataController
extends BaseController<ChartData, ChartDataService> {
    @Autowired
    private ChartDataService chartDataService;

    @ApiOperation(value="\u56fe\u8868\u6570\u636e-\u6839\u636e\u6570\u636eid\u83b7\u53d6\u6570\u636e", notes="\u56fe\u8868\u6570\u636e-\u6839\u636e\u6570\u636eid\u83b7\u53d6\u6570\u636e")
    @GetMapping(value={"/getData/{dataId}"})
    public Result<?> getData(@PathVariable(value="dataId") String dataId) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        LoginUser sysUser = SysUtil.getLoginUser();
        dataMap.put("user", sysUser);
        dataMap.putAll(BeanUtils.beanToMap((Object)sysUser));
        Session session = SecurityUtils.getSubject().getSession();
        for (Object key : session.getAttributeKeys()) {
            dataMap.put(key.toString(), session.getAttribute(key));
        }
        ChartDataVO chartDataVO = this.chartDataService.getDataById(dataId, dataMap);
        return Result.ok((Object)chartDataVO);
    }

    @ApiOperation(value="\u56fe\u8868\u6570\u636e-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u56fe\u8868\u6570\u636e-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ChartData chartData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)chartData), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.chartDataService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u56fe\u8868\u6570\u636e-\u6dfb\u52a0", logType=2, operateType=2)
    @ApiOperation(value="\u56fe\u8868\u6570\u636e-\u6dfb\u52a0", notes="\u56fe\u8868\u6570\u636e-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ChartData chartData) {
        this.chartDataService.saveChartData(chartData);
        return this.commonSuccessResult(2);
    }

    @AutoLog(value="\u56fe\u8868\u6570\u636e-\u7f16\u8f91", logType=2, operateType=3)
    @ApiOperation(value="\u56fe\u8868\u6570\u636e-\u7f16\u8f91", notes="\u56fe\u8868\u6570\u636e-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ChartData chartData) {
        this.chartDataService.updateChartData(chartData);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u56fe\u8868\u6570\u636e-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u56fe\u8868\u6570\u636e-\u901a\u8fc7id\u5220\u9664", notes="\u56fe\u8868\u6570\u636e-\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.chartDataService.delChartData(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u56fe\u8868\u6570\u636e-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u56fe\u8868\u6570\u636e-\u6279\u91cf\u5220\u9664", notes="\u56fe\u8868\u6570\u636e-\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.chartDataService.delBatchChartData(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u56fe\u8868\u6570\u636e-\u901a\u8fc7id\u67e5\u8be2", notes="\u56fe\u8868\u6570\u636e-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ChartData chartData = (ChartData)((Object)this.chartDataService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)chartData));
    }

    @PostMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, CharDataExportServiceImpl.class);
    }
}

