/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dashboard.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.dashboard.entity.ChartConfig;
import com.els.modules.dashboard.entity.ChartData;
import com.els.modules.dashboard.entity.Dashboard;
import com.els.modules.dashboard.entity.DashboardChart;
import com.els.modules.dashboard.mapper.DashboardChartMapper;
import com.els.modules.dashboard.mapper.DashboardMapper;
import com.els.modules.dashboard.service.ChartConfigService;
import com.els.modules.dashboard.service.ChartDataService;
import com.els.modules.dashboard.service.DashboardChartService;
import com.els.modules.dashboard.service.DashboardService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DashboardServiceImpl
extends ServiceImpl<DashboardMapper, Dashboard>
implements DashboardService {
    @Resource
    private DashboardMapper dashboardMapper;
    @Resource
    private DashboardChartMapper dashboardChartMapper;
    @Autowired
    private DashboardChartService dashboardChartService;
    @Autowired
    private ChartDataService chartDataService;
    @Autowired
    private ChartConfigService chartConfigService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(Dashboard dashboard, List<DashboardChart> dashboardChartList) {
        this.dashboardMapper.insert((Object)dashboard);
        for (DashboardChart entity : dashboardChartList) {
            entity.setDashboardId(dashboard.getId());
            this.dashboardChartMapper.insert((Object)entity);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(Dashboard dashboard, List<DashboardChart> dashboardChartList) {
        this.dashboardMapper.updateById((Object)dashboard);
        this.dashboardChartMapper.deleteByMainId(dashboard.getId());
        for (DashboardChart entity : dashboardChartList) {
            entity.setDashboardId(dashboard.getId());
            this.dashboardChartMapper.insert((Object)entity);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.dashboardChartMapper.deleteByMainId(id);
        this.dashboardMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.dashboardChartMapper.deleteByMainId(serializable.toString());
            this.dashboardMapper.deleteById(serializable);
        }
    }

    @Override
    public void shareElsWork(List<String> elsAccountList) {
        List dataList = ((LambdaQueryChainWrapper)this.chartDataService.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)"100000")).list();
        ArrayList dataListNew = new ArrayList();
        List configList = ((LambdaQueryChainWrapper)this.chartConfigService.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)"100000")).list();
        ArrayList configListNew = new ArrayList();
        List dashboardList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)"100000")).list();
        ArrayList<Dashboard> dashboardListNew = new ArrayList<Dashboard>();
        List dashboardChartList = ((LambdaQueryChainWrapper)this.dashboardChartService.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)"100000")).list();
        ArrayList dashboardChartListnew = new ArrayList();
        for (String elsAccount : elsAccountList) {
            List configListAccount = ((LambdaQueryChainWrapper)this.chartConfigService.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).list();
            if (CollectionUtil.isNotEmpty((Collection)configListAccount) && configListAccount.size() >= configList.size()) continue;
            this.delChartData(elsAccount);
            for (Dashboard dashboard : dashboardList) {
                Dashboard dashboardNew = new Dashboard();
                SysUtil.copyProperties((Object)((Object)dashboard), (Object)((Object)dashboardNew));
                dashboardNew.setId(IdWorker.getIdStr());
                dashboardNew.setElsAccount(elsAccount);
                dashboardNew.setCreateTime(null);
                dashboardNew.setUpdateTime(null);
                dashboardListNew.add(dashboardNew);
                dashboardChartList.forEach(item -> {
                    if (item.getDashboardId().equals(dashboard.getId())) {
                        DashboardChart dashboardChartNew = new DashboardChart();
                        SysUtil.copyProperties((Object)item, (Object)((Object)dashboardChartNew));
                        dashboardChartNew.setId(IdWorker.getIdStr());
                        dashboardChartNew.setElsAccount(elsAccount);
                        dashboardChartNew.setCreateTime(null);
                        dashboardChartNew.setUpdateTime(null);
                        configList.forEach(config -> {
                            if (item.getChartId().equals(config.getId())) {
                                ChartConfig configNew = new ChartConfig();
                                SysUtil.copyProperties((Object)config, (Object)((Object)configNew));
                                configNew.setId(IdWorker.getIdStr());
                                configNew.setElsAccount(elsAccount);
                                configNew.setCreateTime(null);
                                configNew.setUpdateTime(null);
                                dataList.forEach(data -> {
                                    if (data.getId().equals(config.getDataId())) {
                                        ChartData chartDataNew = new ChartData();
                                        SysUtil.copyProperties((Object)data, (Object)((Object)chartDataNew));
                                        chartDataNew.setId(IdWorker.getIdStr());
                                        chartDataNew.setElsAccount(elsAccount);
                                        chartDataNew.setCreateTime(null);
                                        chartDataNew.setUpdateTime(null);
                                        configNew.setDataId(chartDataNew.getId());
                                        dataListNew.add(chartDataNew);
                                    }
                                });
                                configListNew.add(configNew);
                                dashboardChartNew.setChartId(configNew.getId());
                            }
                        });
                        dashboardChartListnew.add(dashboardChartNew);
                    }
                });
            }
        }
        if (CollectionUtil.isNotEmpty(dataListNew)) {
            this.chartDataService.saveBatch(dataListNew);
        }
        if (CollectionUtil.isNotEmpty(configListNew)) {
            this.chartConfigService.saveBatch(configListNew);
        }
        if (CollectionUtil.isNotEmpty(dashboardListNew)) {
            this.saveBatch(dashboardListNew);
        }
        if (CollectionUtil.isNotEmpty(dashboardChartListnew)) {
            this.dashboardChartService.saveBatch(dashboardChartListnew);
        }
    }

    private void delChartData(String elsAccount) {
        List list = ((LambdaQueryChainWrapper)this.chartDataService.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).list();
        List configList = ((LambdaQueryChainWrapper)this.chartConfigService.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).list();
        List dashboardList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).list();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            this.chartDataService.delBatchChartData(list.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty((Collection)configList)) {
            this.chartConfigService.delBatchChartConfig(configList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty((Collection)dashboardList)) {
            this.delBatchMain(dashboardList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList()));
        }
    }
}

