/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.data.listener;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.data.mapper.DataSyncMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.stereotype.Component;

@Component
public class DataSyncConsumer {
    private static final Logger log = LoggerFactory.getLogger(DataSyncConsumer.class);
    @Autowired
    private DataSyncMapper dataSyncMapper;

    @StreamListener(value="input")
    public void receive(String msgBody) {
        log.debug("msgBody: " + msgBody);
        try {
            if (StrUtil.isBlank((CharSequence)msgBody)) {
                return;
            }
            JSONObject body = JSONObject.parseObject((String)msgBody);
            String type = body.getString("type");
            String executeSql = null;
            if ("UPDATE".equals(type)) {
                executeSql = this.getUpdateSql(body);
            } else if ("DELETE".equals(type)) {
                executeSql = this.getDeleteSql(body);
            } else if ("INSERT".equals(type)) {
                executeSql = this.getInsertSql(body);
            } else if ("ALTER".equals(type) || "CREATE".equals(type) || "ERASE".equals(type) || "CINDEX".equals(type) || "DINDEX".equals(type)) {
                executeSql = this.getAlterSql(body);
            }
            log.debug("executeSql:" + executeSql);
            if (executeSql != null) {
                this.dataSyncMapper.executeSql(executeSql);
            }
        }
        catch (Exception e) {
            log.error("DataSyncConsumer_receive_msgBody:" + msgBody, (Throwable)e);
            throw e;
        }
    }

    private String getUpdateSql(JSONObject body) {
        JSONArray dataArray = body.getJSONArray("data");
        JSONArray oldArray = body.getJSONArray("old");
        JSONArray pkNames = body.getJSONArray("pkNames");
        String tableName = body.getString("table");
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONObject dataObj = (JSONObject)dataArray.get(i);
            JSONObject oldObj = (JSONObject)oldArray.get(i);
            sql.append("UPDATE ").append(tableName).append(" SET ");
            StringBuilder setSql = new StringBuilder();
            for (String filed : oldObj.keySet()) {
                String value;
                if (setSql.length() != 0) {
                    setSql.append(" , ");
                }
                if (StrUtil.isNotBlank((CharSequence)(value = dataObj.getString(filed)))) {
                    value = value.replaceAll("\\\\", "\\\\\\\\");
                    value = value.replaceAll("\"", "\\\\\"");
                    setSql.append(filed).append("=").append("\"").append(value).append("\" ");
                    continue;
                }
                if (value == null) {
                    setSql.append(filed).append("=").append(value);
                    continue;
                }
                setSql.append(filed).append("=\"\"");
            }
            sql.append((CharSequence)setSql);
            sql.append(" WHERE ");
            StringBuilder whereSql = new StringBuilder();
            for (Object pkName : pkNames) {
                String pk = (String)pkName;
                if (whereSql.length() == 0) {
                    whereSql.append(pk).append(" = ").append("\"").append(dataObj.getString(pk)).append("\" ");
                    continue;
                }
                whereSql.append(" AND ").append(pk).append(" = ").append("\"").append(dataObj.getString(pk)).append("\" ");
            }
            sql.append((CharSequence)whereSql).append(";");
        }
        return sql.toString();
    }

    private String getDeleteSql(JSONObject body) {
        JSONArray dataArray = body.getJSONArray("data");
        JSONArray pkNames = body.getJSONArray("pkNames");
        String tableName = body.getString("table");
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONObject dataObj = (JSONObject)dataArray.get(i);
            sql.append("DELETE FROM ").append(tableName).append(" WHERE ");
            StringBuilder whereSql = new StringBuilder();
            for (Object pkName : pkNames) {
                String pk = (String)pkName;
                if (whereSql.length() == 0) {
                    whereSql.append(pk).append(" = ").append("\"").append(dataObj.getString(pk)).append("\" ");
                    continue;
                }
                whereSql.append(" AND ").append(pk).append(" = ").append("\"").append(dataObj.getString(pk)).append("\" ");
            }
            sql.append((CharSequence)whereSql).append(";");
        }
        return sql.toString();
    }

    private String getInsertSql(JSONObject body) {
        JSONArray dataArray = body.getJSONArray("data");
        String tableName = body.getString("table");
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONObject dataObj = (JSONObject)dataArray.get(i);
            sql.append("REPLACE INTO ").append(tableName).append(" ( ");
            StringBuilder filedSql = new StringBuilder();
            StringBuilder valueSql = new StringBuilder();
            for (String filed : dataObj.keySet()) {
                String value = dataObj.getString(filed);
                if (value == null) continue;
                value = value.replaceAll("\\\\", "\\\\\\\\");
                value = value.replaceAll("\"", "\\\\\"");
                if (filedSql.length() == 0) {
                    filedSql.append(filed);
                    valueSql.append("\"").append(value).append("\" ");
                    continue;
                }
                filedSql.append(",").append(filed);
                valueSql.append(",").append("\"").append(value).append("\" ");
            }
            sql.append((CharSequence)filedSql).append(") VALUES (");
            sql.append((CharSequence)valueSql).append(");");
        }
        return sql.toString();
    }

    private String getAlterSql(JSONObject body) {
        String sql = body.getString("sql");
        String database = body.getString("database");
        sql = sql.replaceAll("`", "");
        sql = sql.replaceAll(database + ".", "");
        return sql;
    }
}

