/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dataSource.config;

import com.alibaba.druid.pool.DruidDataSource;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="spring.datasource.dynamic.druid")
public class DruidProperties {
    private int initialSize;
    private int minIdle;
    private int maxActive;
    private int maxWait;
    private int timeBetweenEvictionRunsMillis;
    private int minEvictableIdleTimeMillis;
    private boolean testWhileIdle;
    private boolean poolPreparedStatements;
    private int maxPoolPreparedStatementPerConnectionSize;
    private int connectionErrorRetryAttempts;
    private boolean breakAfterAcquireFailure;
    private int timeBetweenConnectErrorMillis;

    public DruidDataSource dataSource(String url, String username, String password, String driverClassName) {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(url);
        datasource.setUsername(username);
        datasource.setPassword(password);
        datasource.setDriverClassName(driverClassName);
        datasource.setInitialSize(this.initialSize);
        datasource.setMinIdle(this.minIdle);
        datasource.setMaxActive(this.maxActive);
        datasource.setMaxWait((long)this.maxWait);
        datasource.setTimeBetweenEvictionRunsMillis((long)this.timeBetweenEvictionRunsMillis);
        datasource.setMinEvictableIdleTimeMillis((long)this.minEvictableIdleTimeMillis);
        datasource.setTestWhileIdle(this.testWhileIdle);
        datasource.setPoolPreparedStatements(this.poolPreparedStatements);
        datasource.setMaxPoolPreparedStatementPerConnectionSize(this.maxPoolPreparedStatementPerConnectionSize);
        datasource.setConnectionErrorRetryAttempts(this.connectionErrorRetryAttempts);
        datasource.setBreakAfterAcquireFailure(this.breakAfterAcquireFailure);
        datasource.setTimeBetweenConnectErrorMillis((long)this.timeBetweenConnectErrorMillis);
        return datasource;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public int getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public int getMaxPoolPreparedStatementPerConnectionSize() {
        return this.maxPoolPreparedStatementPerConnectionSize;
    }

    public int getConnectionErrorRetryAttempts() {
        return this.connectionErrorRetryAttempts;
    }

    public boolean isBreakAfterAcquireFailure() {
        return this.breakAfterAcquireFailure;
    }

    public int getTimeBetweenConnectErrorMillis() {
        return this.timeBetweenConnectErrorMillis;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public void setMinEvictableIdleTimeMillis(int minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public void setPoolPreparedStatements(boolean poolPreparedStatements) {
        this.poolPreparedStatements = poolPreparedStatements;
    }

    public void setMaxPoolPreparedStatementPerConnectionSize(int maxPoolPreparedStatementPerConnectionSize) {
        this.maxPoolPreparedStatementPerConnectionSize = maxPoolPreparedStatementPerConnectionSize;
    }

    public void setConnectionErrorRetryAttempts(int connectionErrorRetryAttempts) {
        this.connectionErrorRetryAttempts = connectionErrorRetryAttempts;
    }

    public void setBreakAfterAcquireFailure(boolean breakAfterAcquireFailure) {
        this.breakAfterAcquireFailure = breakAfterAcquireFailure;
    }

    public void setTimeBetweenConnectErrorMillis(int timeBetweenConnectErrorMillis) {
        this.timeBetweenConnectErrorMillis = timeBetweenConnectErrorMillis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DruidProperties)) {
            return false;
        }
        DruidProperties other = (DruidProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInitialSize() != other.getInitialSize()) {
            return false;
        }
        if (this.getMinIdle() != other.getMinIdle()) {
            return false;
        }
        if (this.getMaxActive() != other.getMaxActive()) {
            return false;
        }
        if (this.getMaxWait() != other.getMaxWait()) {
            return false;
        }
        if (this.getTimeBetweenEvictionRunsMillis() != other.getTimeBetweenEvictionRunsMillis()) {
            return false;
        }
        if (this.getMinEvictableIdleTimeMillis() != other.getMinEvictableIdleTimeMillis()) {
            return false;
        }
        if (this.isTestWhileIdle() != other.isTestWhileIdle()) {
            return false;
        }
        if (this.isPoolPreparedStatements() != other.isPoolPreparedStatements()) {
            return false;
        }
        if (this.getMaxPoolPreparedStatementPerConnectionSize() != other.getMaxPoolPreparedStatementPerConnectionSize()) {
            return false;
        }
        if (this.getConnectionErrorRetryAttempts() != other.getConnectionErrorRetryAttempts()) {
            return false;
        }
        if (this.isBreakAfterAcquireFailure() != other.isBreakAfterAcquireFailure()) {
            return false;
        }
        return this.getTimeBetweenConnectErrorMillis() == other.getTimeBetweenConnectErrorMillis();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DruidProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInitialSize();
        result = result * 59 + this.getMinIdle();
        result = result * 59 + this.getMaxActive();
        result = result * 59 + this.getMaxWait();
        result = result * 59 + this.getTimeBetweenEvictionRunsMillis();
        result = result * 59 + this.getMinEvictableIdleTimeMillis();
        result = result * 59 + (this.isTestWhileIdle() ? 79 : 97);
        result = result * 59 + (this.isPoolPreparedStatements() ? 79 : 97);
        result = result * 59 + this.getMaxPoolPreparedStatementPerConnectionSize();
        result = result * 59 + this.getConnectionErrorRetryAttempts();
        result = result * 59 + (this.isBreakAfterAcquireFailure() ? 79 : 97);
        result = result * 59 + this.getTimeBetweenConnectErrorMillis();
        return result;
    }

    public String toString() {
        return "DruidProperties(initialSize=" + this.getInitialSize() + ", minIdle=" + this.getMinIdle() + ", maxActive=" + this.getMaxActive() + ", maxWait=" + this.getMaxWait() + ", timeBetweenEvictionRunsMillis=" + this.getTimeBetweenEvictionRunsMillis() + ", minEvictableIdleTimeMillis=" + this.getMinEvictableIdleTimeMillis() + ", testWhileIdle=" + this.isTestWhileIdle() + ", poolPreparedStatements=" + this.isPoolPreparedStatements() + ", maxPoolPreparedStatementPerConnectionSize=" + this.getMaxPoolPreparedStatementPerConnectionSize() + ", connectionErrorRetryAttempts=" + this.getConnectionErrorRetryAttempts() + ", breakAfterAcquireFailure=" + this.isBreakAfterAcquireFailure() + ", timeBetweenConnectErrorMillis=" + this.getTimeBetweenConnectErrorMillis() + ")";
    }
}

