/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dataSource.config;

import com.alibaba.fastjson.JSON;
import com.els.modules.dataSource.config.HttpClientPoolConfig;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.ssl.SSLContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configuration
public class HttpClientConfig {
    private static final Logger log = LoggerFactory.getLogger(HttpClientConfig.class);
    @Autowired
    private HttpClientPoolConfig httpClientPoolConfig;

    @Bean(name={"clientHttpRequestFactory"})
    public ClientHttpRequestFactory clientHttpRequestFactory() {
        if (this.httpClientPoolConfig.getMaxTotalConnect() <= 0) {
            throw new IllegalArgumentException("invalid maxTotalConnection: " + this.httpClientPoolConfig.getMaxTotalConnect());
        }
        if (this.httpClientPoolConfig.getMaxConnectPerRoute() <= 0) {
            throw new IllegalArgumentException("invalid maxConnectionPerRoute: " + this.httpClientPoolConfig.getMaxConnectPerRoute());
        }
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory(this.httpClient());
        clientHttpRequestFactory.setConnectTimeout(this.httpClientPoolConfig.getConnectTimeout());
        clientHttpRequestFactory.setReadTimeout(this.httpClientPoolConfig.getReadTimeout());
        clientHttpRequestFactory.setConnectionRequestTimeout(this.httpClientPoolConfig.getConnectionRequestTimout());
        return clientHttpRequestFactory;
    }

    @Bean(name={"dataSourceRestTemplate"})
    public RestTemplate restTemplate(@Qualifier(value="clientHttpRequestFactory") ClientHttpRequestFactory factory) {
        return this.createRestTemplate(factory);
    }

    @Bean
    public HttpClient httpClient() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (arg0, arg1) -> true).build();
            httpClientBuilder.setSSLContext(sslContext);
            NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
            PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            poolingHttpClientConnectionManager.setMaxTotal(this.httpClientPoolConfig.getMaxTotalConnect());
            poolingHttpClientConnectionManager.setDefaultMaxPerRoute(this.httpClientPoolConfig.getMaxConnectPerRoute());
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager);
            httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(this.httpClientPoolConfig.getRetryTimes(), true));
            List<Header> headers = this.getDefaultHeaders();
            httpClientBuilder.setDefaultHeaders(headers);
            httpClientBuilder.setKeepAliveStrategy(this.connectionKeepAliveStrategy());
            return httpClientBuilder.build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            log.error("\u521d\u59cb\u5316HTTP\u8fde\u63a5\u6c60\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public ConnectionKeepAliveStrategy connectionKeepAliveStrategy() {
        return (response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                log.info("HeaderElement:{}", (Object)JSON.toJSONString((Object)he));
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !"timeout".equalsIgnoreCase(param)) continue;
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (NumberFormatException ignore) {
                    log.error("\u89e3\u6790\u957f\u8fde\u63a5\u8fc7\u671f\u65f6\u95f4\u5f02\u5e38", (Throwable)ignore);
                }
            }
            HttpHost target = (HttpHost)context.getAttribute("http.target_host");
            Optional<Map.Entry> any = Optional.ofNullable(this.httpClientPoolConfig.getKeepAliveTargetHost()).orElseGet(HashMap::new).entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(target.getHostName())).findAny();
            return any.map(en -> (long)((Integer)en.getValue()).intValue() * 1000L).orElse((long)this.httpClientPoolConfig.getKeepAliveTime() * 1000L);
        };
    }

    private List<Header> getDefaultHeaders() {
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add((Header)new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.16 Safari/537.36"));
        headers.add((Header)new BasicHeader("Accept-Encoding", "gzip,deflate"));
        headers.add((Header)new BasicHeader("Accept-Language", "zh-CN"));
        headers.add((Header)new BasicHeader("Connection", "Keep-Alive"));
        return headers;
    }

    private RestTemplate createRestTemplate(ClientHttpRequestFactory factory) {
        RestTemplate restTemplate = new RestTemplate(factory);
        this.modifyDefaultCharset(restTemplate);
        restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler());
        return restTemplate;
    }

    private void modifyDefaultCharset(RestTemplate restTemplate) {
        List converterList = restTemplate.getMessageConverters();
        HttpMessageConverter converterTarget = null;
        for (HttpMessageConverter item : converterList) {
            if (StringHttpMessageConverter.class != item.getClass()) continue;
            converterTarget = item;
            break;
        }
        if (null != converterTarget) {
            converterList.remove(converterTarget);
        }
        Charset defaultCharset = Charset.forName(this.httpClientPoolConfig.getCharset());
        converterList.add(1, new StringHttpMessageConverter(defaultCharset));
    }
}

