/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dataSource.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.dataSource.entity.DataSetTestTransformParam;
import com.els.modules.dataSource.entity.ElsChartDataSet;
import com.els.modules.dataSource.entity.ElsReportChartDataSet;
import com.els.modules.dataSource.service.ElsReportChartDataSetService;
import com.els.modules.dataSource.service.ElsReportChartDataSourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u96c6\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/dataSource/elsReportChartDataSet"})
public class ElsReportChartDataSetController
extends BaseController<ElsReportChartDataSet, ElsReportChartDataSetService> {
    @Autowired
    private ElsReportChartDataSetService elsReportChartDataSetService;
    @Autowired
    private ElsReportChartDataSourceService elsReportChartDataSourceService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"dataSource#elsReportChartDataSet:list"})
    public Result<?> queryPageList(ElsReportChartDataSet elsReportChartDataSet, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsReportChartDataSet), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsReportChartDataSetService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u6570\u636e\u96c6\u7ba1\u7406-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"dataSource#elsReportChartDataSet:add"})
    public Result<?> add(@RequestBody ElsChartDataSet elsReportChartDataSet) {
        this.elsReportChartDataSetService.insertSet(elsReportChartDataSet);
        ElsChartDataSet elsChartDataSet = this.elsReportChartDataSetService.detailSet(elsReportChartDataSet.getSetCode());
        return Result.ok((Object)elsChartDataSet);
    }

    @AutoLog(value="\u6570\u636e\u96c6\u7ba1\u7406-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"dataSource#elsReportChartDataSet:edit"})
    public Result<?> edit(@RequestBody ElsChartDataSet elsReportChartDataSet) {
        this.elsReportChartDataSetService.updateSet(elsReportChartDataSet);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u6570\u636e\u96c6\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"dataSource#elsReportChartDataSet:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.elsReportChartDataSetService.deleteSet(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6570\u636e\u96c6\u7ba1\u7406-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"dataSource#elsReportChartDataSet:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.elsReportChartDataSetService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"dataSource#elsReportChartDataSet:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ElsChartDataSet elsReportChartDataSet = this.elsReportChartDataSetService.detailSet(id);
        return Result.ok((Object)elsReportChartDataSet);
    }

    @PostMapping(value={"/testTransform"})
    @RequiresPermissions(value={"dataSource#elsReportChartDataSet:testTransform"})
    public Result<?> testTransform(@Validated @RequestBody DataSetTestTransformParam param) {
        ElsChartDataSet dto = new ElsChartDataSet();
        BeanUtils.copyProperties((Object)param, (Object)dto);
        return Result.ok((Object)this.elsReportChartDataSetService.testTransform(dto));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/getDataById"})
    @RequiresPermissions(value={"dataSource#elsReportChartDataSet:view"})
    public Result<?> getDataById(@RequestParam(name="id") String id) {
        ElsChartDataSet elsReportChartDataSet = this.elsReportChartDataSetService.detailSet(id);
        return Result.ok((Object)this.elsReportChartDataSetService.testTransform(elsReportChartDataSet));
    }

    @GetMapping(value={"/queryAllDataSet"})
    @RequiresPermissions(value={"dataSource#elsReportChartDataSet:queryAllDataSet"})
    public Result<?> queryAllDataSet() {
        return Result.ok(this.elsReportChartDataSetService.queryAllDataSet());
    }
}

