/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dataSource.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.modules.dataSource.entity.ElsReportChartDataSetTransform;
import com.els.modules.dataSource.service.TransformStrategy;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DictTransformServiceImpl
implements TransformStrategy {
    private static final Logger log = LoggerFactory.getLogger(DictTransformServiceImpl.class);

    @Override
    public String type() {
        return "dict";
    }

    @Override
    public List<JSONObject> transform(ElsReportChartDataSetTransform def, List<JSONObject> data) {
        String transformScript = def.getTransformScript();
        if (StringUtils.isBlank((CharSequence)transformScript)) {
            return data;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)transformScript);
        Set keys = jsonObject.keySet();
        data.forEach(dataDetail -> dataDetail.forEach((key, value) -> {
            String string;
            if (keys.contains(key) && StringUtils.isNotBlank((CharSequence)(string = jsonObject.getJSONObject(key).getString(value.toString())))) {
                dataDetail.put(key, (Object)string);
            }
        }));
        return data;
    }
}

